/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kubernetes;

import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.kubernetes.ContainerImage;
import org.openrewrite.kubernetes.tree.K8S;
import org.openrewrite.marker.Marker;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.YamlVisitor;
import org.openrewrite.yaml.search.YamlSearchResult;
import org.openrewrite.yaml.tree.Yaml;

public final class UpdateContainerImageName
extends Recipe {
    @Option(displayName="Repository to find", description="The repository part of the image name to search for in containers and initContainers.", example="gcr.io", required=false)
    @Nullable
    private final String repoToFind;
    @Option(displayName="Image name to find", description="The image name to search for in containers and initContainers.", example="nginx")
    private final String imageToFind;
    @Option(displayName="Image tag to find", description="The tag part of the image name to search for in containers and initContainers.", example="v1.2.3", required=false)
    @Nullable
    private final String tagToFind;
    @Option(displayName="Repository to update", description="The repository part of the image name to update to in containers and initContainers.", example="gcr.io/account/bucket", required=false)
    @Nullable
    private final String repoToUpdate;
    @Option(displayName="Image name to update", description="The image name to update to in containers and initContainers.", example="nginx", required=false)
    @Nullable
    private final String imageToUpdate;
    @Option(displayName="Image tag to update", description="The tag part of the image name to update to in containers and initContainers.", example="v1.2.3", required=false)
    @Nullable
    private final String tagToUpdate;
    @Option(displayName="Include initContainers", description="Boolean to indicate whether or not to treat initContainers/image identically to containers/image.", example="false")
    private final boolean includeInitContainers;

    public String getDisplayName() {
        return "Update image name";
    }

    public String getDescription() {
        return "Search for image names that match patterns and replace the components of the name with new values.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        final YamlSearchResult result = new YamlSearchResult((Recipe)this);
        return new YamlVisitor<ExecutionContext>(){

            public Yaml visitDocument(Yaml.Document document, ExecutionContext executionContext) {
                Cursor c = this.getCursor();
                if (K8S.inPod(c) || K8S.inDeployment(c) || K8S.inStatefulSet(c) || K8S.inDaemonSet(c)) {
                    return document.withMarkers(document.getMarkers().addIfAbsent((Marker)result));
                }
                return document;
            }
        };
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        final ContainerImage.ImageName imageToSearch = new ContainerImage.ImageName(this.repoToFind, this.imageToFind, this.tagToFind, "*");
        return new YamlIsoVisitor<ExecutionContext>(){

            public Yaml.Scalar visitScalar(Yaml.Scalar scalar, ExecutionContext ctx) {
                ContainerImage image;
                Cursor c = this.getCursor();
                if ((K8S.Containers.inContainerSpec(c) || UpdateContainerImageName.this.includeInitContainers && K8S.InitContainers.inInitContainerSpec(c)) && K8S.Containers.isImageName(c) && (image = new ContainerImage(scalar.getValue())).getImageName().matches(imageToSearch)) {
                    ContainerImage.ImageName newName = image.getImageName();
                    if (null != UpdateContainerImageName.this.repoToUpdate) {
                        newName = newName.withRepository(UpdateContainerImageName.this.repoToUpdate);
                    }
                    if (null != UpdateContainerImageName.this.imageToUpdate) {
                        newName = newName.withImage(UpdateContainerImageName.this.imageToUpdate);
                    }
                    if (null != UpdateContainerImageName.this.tagToUpdate) {
                        newName = newName.withTag(UpdateContainerImageName.this.tagToUpdate);
                    }
                    return scalar.withValue(newName.toString());
                }
                return super.visitScalar(scalar, (Object)ctx);
            }
        };
    }

    public UpdateContainerImageName(String repoToFind, String imageToFind, String tagToFind, String repoToUpdate, String imageToUpdate, String tagToUpdate, boolean includeInitContainers) {
        this.repoToFind = repoToFind;
        this.imageToFind = imageToFind;
        this.tagToFind = tagToFind;
        this.repoToUpdate = repoToUpdate;
        this.imageToUpdate = imageToUpdate;
        this.tagToUpdate = tagToUpdate;
        this.includeInitContainers = includeInitContainers;
    }

    public String getRepoToFind() {
        return this.repoToFind;
    }

    public String getImageToFind() {
        return this.imageToFind;
    }

    public String getTagToFind() {
        return this.tagToFind;
    }

    public String getRepoToUpdate() {
        return this.repoToUpdate;
    }

    public String getImageToUpdate() {
        return this.imageToUpdate;
    }

    public String getTagToUpdate() {
        return this.tagToUpdate;
    }

    public boolean isIncludeInitContainers() {
        return this.includeInitContainers;
    }

    public String toString() {
        return "UpdateContainerImageName(repoToFind=" + this.getRepoToFind() + ", imageToFind=" + this.getImageToFind() + ", tagToFind=" + this.getTagToFind() + ", repoToUpdate=" + this.getRepoToUpdate() + ", imageToUpdate=" + this.getImageToUpdate() + ", tagToUpdate=" + this.getTagToUpdate() + ", includeInitContainers=" + this.isIncludeInitContainers() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateContainerImageName)) {
            return false;
        }
        UpdateContainerImageName other = (UpdateContainerImageName)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isIncludeInitContainers() != other.isIncludeInitContainers()) {
            return false;
        }
        String this$repoToFind = this.getRepoToFind();
        String other$repoToFind = other.getRepoToFind();
        if (this$repoToFind == null ? other$repoToFind != null : !this$repoToFind.equals(other$repoToFind)) {
            return false;
        }
        String this$imageToFind = this.getImageToFind();
        String other$imageToFind = other.getImageToFind();
        if (this$imageToFind == null ? other$imageToFind != null : !this$imageToFind.equals(other$imageToFind)) {
            return false;
        }
        String this$tagToFind = this.getTagToFind();
        String other$tagToFind = other.getTagToFind();
        if (this$tagToFind == null ? other$tagToFind != null : !this$tagToFind.equals(other$tagToFind)) {
            return false;
        }
        String this$repoToUpdate = this.getRepoToUpdate();
        String other$repoToUpdate = other.getRepoToUpdate();
        if (this$repoToUpdate == null ? other$repoToUpdate != null : !this$repoToUpdate.equals(other$repoToUpdate)) {
            return false;
        }
        String this$imageToUpdate = this.getImageToUpdate();
        String other$imageToUpdate = other.getImageToUpdate();
        if (this$imageToUpdate == null ? other$imageToUpdate != null : !this$imageToUpdate.equals(other$imageToUpdate)) {
            return false;
        }
        String this$tagToUpdate = this.getTagToUpdate();
        String other$tagToUpdate = other.getTagToUpdate();
        return !(this$tagToUpdate == null ? other$tagToUpdate != null : !this$tagToUpdate.equals(other$tagToUpdate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UpdateContainerImageName;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isIncludeInitContainers() ? 79 : 97);
        String $repoToFind = this.getRepoToFind();
        result = result * 59 + ($repoToFind == null ? 43 : $repoToFind.hashCode());
        String $imageToFind = this.getImageToFind();
        result = result * 59 + ($imageToFind == null ? 43 : $imageToFind.hashCode());
        String $tagToFind = this.getTagToFind();
        result = result * 59 + ($tagToFind == null ? 43 : $tagToFind.hashCode());
        String $repoToUpdate = this.getRepoToUpdate();
        result = result * 59 + ($repoToUpdate == null ? 43 : $repoToUpdate.hashCode());
        String $imageToUpdate = this.getImageToUpdate();
        result = result * 59 + ($imageToUpdate == null ? 43 : $imageToUpdate.hashCode());
        String $tagToUpdate = this.getTagToUpdate();
        result = result * 59 + ($tagToUpdate == null ? 43 : $tagToUpdate.hashCode());
        return result;
    }
}

