/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kubernetes.search;

import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.kubernetes.ContainerImage;
import org.openrewrite.kubernetes.tree.K8S;
import org.openrewrite.marker.Marker;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.search.YamlSearchResult;
import org.openrewrite.yaml.tree.Yaml;

public final class FindMissingDigest
extends Recipe {
    @Option(displayName="Include initContainers", description="Boolean to indicate whether or not to treat initContainers/image identically to containers/image.")
    private final boolean includeInitContainers;

    public String getDisplayName() {
        return "Find missing digest";
    }

    public String getDescription() {
        return "Find instances of a container name that fails to specify a digest.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        final YamlSearchResult result = new YamlSearchResult((Recipe)this, "missing digest");
        return new YamlIsoVisitor<ExecutionContext>(){

            public Yaml.Scalar visitScalar(Yaml.Scalar scalar, ExecutionContext ctx) {
                ContainerImage image;
                Cursor c = this.getCursor();
                if ((K8S.Containers.inContainerSpec(c) || FindMissingDigest.this.includeInitContainers && K8S.InitContainers.inInitContainerSpec(c)) && K8S.Containers.isImageName(c) && !(image = new ContainerImage(scalar.getValue())).getImageName().hasDigest()) {
                    return scalar.withMarkers(scalar.getMarkers().addIfAbsent((Marker)result));
                }
                return super.visitScalar(scalar, (Object)ctx);
            }
        };
    }

    public FindMissingDigest(boolean includeInitContainers) {
        this.includeInitContainers = includeInitContainers;
    }

    public boolean isIncludeInitContainers() {
        return this.includeInitContainers;
    }

    public String toString() {
        return "FindMissingDigest(includeInitContainers=" + this.isIncludeInitContainers() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindMissingDigest)) {
            return false;
        }
        FindMissingDigest other = (FindMissingDigest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.isIncludeInitContainers() == other.isIncludeInitContainers();
    }

    protected boolean canEqual(Object other) {
        return other instanceof FindMissingDigest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isIncludeInitContainers() ? 79 : 97);
        return result;
    }
}

