/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kubernetes.search;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.kubernetes.tree.K8S;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.RecipeSearchResult;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class FindResourceMissingConfiguration
extends Recipe {
    @Option(displayName="Resource kind", description="The Kubernetes resource type to search on.", example="Pod", required=false)
    @Nullable
    private final String resourceKind;
    @Option(displayName="Configuration path", description="An XPath expression to locate Kubernetes configuration.", example="/spec/containers/livenessProbe")
    private final String configurationPath;

    public String getDisplayName() {
        return "Missing configuration";
    }

    public String getDescription() {
        return "Find Kubernetes resources with missing configuration.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        final RecipeSearchResult result = new RecipeSearchResult(Tree.randomId(), (Recipe)this);
        return new YamlIsoVisitor<ExecutionContext>(){

            public Yaml.Document visitDocument(Yaml.Document document, ExecutionContext ctx) {
                boolean inKind;
                Yaml.Block b = (Yaml.Block)this.visit((Tree)document.getBlock(), ctx, this.getCursor());
                boolean bl = inKind = FindResourceMissingConfiguration.this.resourceKind == null || K8S.inKind(FindResourceMissingConfiguration.this.resourceKind, this.getCursor());
                if (inKind && !"true".equals(this.getCursor().getMessage(FindResourceMissingConfiguration.class.getSimpleName()))) {
                    return document.withBlock(b).withMarkers(document.getMarkers().addIfAbsent((Marker)result));
                }
                return document;
            }

            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                if (K8S.firstEnclosingEntryMatching(FindResourceMissingConfiguration.this.configurationPath, this.getCursor()).isPresent()) {
                    this.getCursor().putMessageOnFirstEnclosing(Yaml.Document.class, FindResourceMissingConfiguration.class.getSimpleName(), (Object)"true");
                }
                return super.visitMappingEntry(entry, (Object)ctx);
            }
        };
    }

    public FindResourceMissingConfiguration(String resourceKind, String configurationPath) {
        this.resourceKind = resourceKind;
        this.configurationPath = configurationPath;
    }

    public String getResourceKind() {
        return this.resourceKind;
    }

    public String getConfigurationPath() {
        return this.configurationPath;
    }

    public String toString() {
        return "FindResourceMissingConfiguration(resourceKind=" + this.getResourceKind() + ", configurationPath=" + this.getConfigurationPath() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindResourceMissingConfiguration)) {
            return false;
        }
        FindResourceMissingConfiguration other = (FindResourceMissingConfiguration)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$resourceKind = this.getResourceKind();
        String other$resourceKind = other.getResourceKind();
        if (this$resourceKind == null ? other$resourceKind != null : !this$resourceKind.equals(other$resourceKind)) {
            return false;
        }
        String this$configurationPath = this.getConfigurationPath();
        String other$configurationPath = other.getConfigurationPath();
        return !(this$configurationPath == null ? other$configurationPath != null : !this$configurationPath.equals(other$configurationPath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FindResourceMissingConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $resourceKind = this.getResourceKind();
        result = result * 59 + ($resourceKind == null ? 43 : $resourceKind.hashCode());
        String $configurationPath = this.getConfigurationPath();
        result = result * 59 + ($configurationPath == null ? 43 : $configurationPath.hashCode());
        return result;
    }
}

