/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kubernetes.services;

import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.kubernetes.search.EntryMarkingVisitor;
import org.openrewrite.kubernetes.tree.K8S;
import org.openrewrite.marker.Marker;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.search.YamlSearchResult;
import org.openrewrite.yaml.tree.Yaml;

public final class FindServicesByType
extends Recipe {
    @Option(displayName="Service type", description="Type of Kubernetes Service to find.", example="NodePort", valid={"ClusterIP", "NodePort", "LoadBalancer", "ExternalName"})
    private final String serviceType;

    public String getDisplayName() {
        return "Service type";
    }

    public String getDescription() {
        return "Type of Kubernetes Service to find.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new YamlIsoVisitor<ExecutionContext>(){

            public Yaml.Document visitDocument(Yaml.Document document, ExecutionContext ctx) {
                if (K8S.inService(this.getCursor())) {
                    return document.withMarkers(document.getMarkers().addIfAbsent((Marker)K8S.asResource((Yaml.Mapping)document.getBlock())));
                }
                return super.visitDocument(document, (Object)ctx);
            }
        };
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        final YamlSearchResult result = new YamlSearchResult((Recipe)this, "type:" + this.serviceType);
        return new EntryMarkingVisitor(){

            public Yaml.Mapping visitMapping(Yaml.Mapping mapping, ExecutionContext ctx) {
                Cursor c = this.getCursor();
                if (K8S.Service.isServiceSpec(c)) {
                    K8S.Service svc = K8S.asService(mapping);
                    if (FindServicesByType.this.serviceType.equals(svc.getType())) {
                        c.getParentOrThrow().putMessageOnFirstEnclosing(Yaml.Mapping.Entry.class, MARKER, (Object)result);
                        return mapping;
                    }
                }
                return super.visitMapping(mapping, (Object)ctx);
            }
        };
    }

    public FindServicesByType(String serviceType) {
        this.serviceType = serviceType;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public String toString() {
        return "FindServicesByType(serviceType=" + this.getServiceType() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindServicesByType)) {
            return false;
        }
        FindServicesByType other = (FindServicesByType)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$serviceType = this.getServiceType();
        String other$serviceType = other.getServiceType();
        return !(this$serviceType == null ? other$serviceType != null : !this$serviceType.equals(other$serviceType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FindServicesByType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $serviceType = this.getServiceType();
        result = result * 59 + ($serviceType == null ? 43 : $serviceType.hashCode());
        return result;
    }
}

