/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kubernetes.services;

import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.kubernetes.tree.K8S;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class UpdateServiceExternalIP
extends Recipe {
    @Option(displayName="IP to find", description="An ExternalIP address to find in the service's external IPs.", example="192.168.0.1")
    private final String ipToFind;
    @Option(displayName="IP to update", description="An ExternalIP address to update to in the service's external IPs.", example="10.10.0.1")
    private final String ipToUpdate;

    public String getDisplayName() {
        return "Update Service ExternalIPs";
    }

    public String getDescription() {
        return "Swap out an IP address with another one in the Service externalIPs setting.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new YamlIsoVisitor<ExecutionContext>(){

            public Yaml.Sequence.Entry visitSequenceEntry(Yaml.Sequence.Entry entry, ExecutionContext ctx) {
                Cursor c = this.getCursor();
                if (K8S.Service.inExternalIPs(c)) {
                    Yaml.Scalar s = (Yaml.Scalar)entry.getBlock();
                    if (UpdateServiceExternalIP.this.ipToFind.equals(s.getValue())) {
                        return entry.withBlock((Yaml.Block)s.withValue(UpdateServiceExternalIP.this.ipToUpdate));
                    }
                }
                return super.visitSequenceEntry(entry, (Object)ctx);
            }
        };
    }

    public UpdateServiceExternalIP(String ipToFind, String ipToUpdate) {
        this.ipToFind = ipToFind;
        this.ipToUpdate = ipToUpdate;
    }

    public String getIpToFind() {
        return this.ipToFind;
    }

    public String getIpToUpdate() {
        return this.ipToUpdate;
    }

    public String toString() {
        return "UpdateServiceExternalIP(ipToFind=" + this.getIpToFind() + ", ipToUpdate=" + this.getIpToUpdate() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateServiceExternalIP)) {
            return false;
        }
        UpdateServiceExternalIP other = (UpdateServiceExternalIP)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$ipToFind = this.getIpToFind();
        String other$ipToFind = other.getIpToFind();
        if (this$ipToFind == null ? other$ipToFind != null : !this$ipToFind.equals(other$ipToFind)) {
            return false;
        }
        String this$ipToUpdate = this.getIpToUpdate();
        String other$ipToUpdate = other.getIpToUpdate();
        return !(this$ipToUpdate == null ? other$ipToUpdate != null : !this$ipToUpdate.equals(other$ipToUpdate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UpdateServiceExternalIP;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $ipToFind = this.getIpToFind();
        result = result * 59 + ($ipToFind == null ? 43 : $ipToFind.hashCode());
        String $ipToUpdate = this.getIpToUpdate();
        result = result * 59 + ($ipToUpdate == null ? 43 : $ipToUpdate.hashCode());
        return result;
    }
}

