/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kubernetes.tree;

import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.kubernetes.resource.ResourceLimit;
import org.openrewrite.marker.Marker;
import org.openrewrite.yaml.XPathMatcher;
import org.openrewrite.yaml.tree.Yaml;

public interface K8S
extends Marker {
    public static boolean inKind(String kind, Cursor cursor) {
        Yaml.Document doc = (Yaml.Document)cursor.firstEnclosing(Yaml.Document.class);
        if (doc == null) {
            return false;
        }
        Resource r = K8S.asResource((Yaml.Mapping)doc.getBlock());
        return kind.equals(r.getKind());
    }

    public static boolean inPod(Cursor cursor) {
        return K8S.inKind("Pod", cursor);
    }

    public static boolean inDaemonSet(Cursor cursor) {
        return K8S.inKind("DaemonSet", cursor);
    }

    public static boolean inStatefulSet(Cursor cursor) {
        return K8S.inKind("StatefulSet", cursor);
    }

    public static boolean inDeployment(Cursor cursor) {
        return K8S.inKind("Deployment", cursor);
    }

    public static boolean inService(Cursor cursor) {
        return K8S.inKind("Service", cursor);
    }

    public static Resource asResource(Yaml.Mapping m) {
        String apiVersion = null;
        String kind = null;
        for (Yaml.Mapping.Entry e : m.getEntries()) {
            Yaml.Block value = e.getValue();
            switch (e.getKey().getValue()) {
                case "apiVersion": {
                    apiVersion = ((Yaml.Scalar)value).getValue();
                    break;
                }
                case "kind": {
                    kind = ((Yaml.Scalar)value).getValue();
                }
            }
        }
        return new Resource(Tree.randomId(), apiVersion, kind);
    }

    public static Annotations asAnnotations(@Nullable Yaml.Mapping m) {
        if (m == null) {
            return new Annotations(Tree.randomId(), Collections.emptySet());
        }
        HashSet<String> keys = new HashSet<String>();
        for (Yaml.Mapping.Entry e : m.getEntries()) {
            keys.add(e.getKey().getValue());
        }
        return new Annotations(Tree.randomId(), keys);
    }

    public static Labels asLabels(@Nullable Yaml.Mapping m) {
        if (m == null) {
            return new Labels(Tree.randomId(), Collections.emptySet());
        }
        HashSet<String> keys = new HashSet<String>();
        for (Yaml.Mapping.Entry e : m.getEntries()) {
            keys.add(e.getKey().getValue());
        }
        return new Labels(Tree.randomId(), keys);
    }

    public static ResourceLimits asResourceLimits(@Nullable Yaml.Scalar s) {
        if (null == s) {
            return new ResourceLimits(Tree.randomId(), null);
        }
        return new ResourceLimits(Tree.randomId(), new ResourceLimit(s.getValue()));
    }

    @Nullable
    public static Service asService(@Nullable Yaml.Mapping m) {
        if (m == null) {
            return null;
        }
        return new Service(Tree.randomId(), m.getEntries().stream().filter(e -> "type".equals(e.getKey().getValue())).findFirst().map(e -> ((Yaml.Scalar)e.getValue()).getValue()).orElse("ClusterIP"));
    }

    public static boolean inMappingEntry(String xpath, @Nullable Cursor cursor) {
        return K8S.inMappingEntry(new XPathMatcher(xpath), cursor);
    }

    public static boolean inMappingEntry(XPathMatcher xpath, @Nullable Cursor cursor) {
        return K8S.firstEnclosingEntryMatching(xpath, cursor).isPresent();
    }

    public static Optional<Cursor> firstEnclosingEntryMatching(String xpath, @Nullable Cursor cursor) {
        return K8S.firstEnclosingEntryMatching(new XPathMatcher(xpath), cursor);
    }

    public static Optional<Cursor> firstEnclosingEntryMatching(XPathMatcher xpath, @Nullable Cursor cursor) {
        Yaml.Mapping.Entry e;
        if (cursor == null) {
            return Optional.empty();
        }
        Yaml.Mapping.Entry entry = e = cursor.getValue() instanceof Yaml.Mapping.Entry ? (Yaml.Mapping.Entry)cursor.getValue() : (Yaml.Mapping.Entry)cursor.firstEnclosing(Yaml.Mapping.Entry.class);
        if (e == null || e.getKey() == cursor.getValue()) {
            return Optional.empty();
        }
        if (xpath.matches(cursor)) {
            return Optional.of(cursor);
        }
        return K8S.firstEnclosingEntryMatching(xpath, cursor.getParent());
    }

    public static class Service
    implements K8S {
        private final UUID id;
        @Nullable
        private final String type;

        public static boolean isServiceSpec(Cursor cursor) {
            return K8S.firstEnclosingEntryMatching("/spec", cursor).filter(c -> c == cursor.getParent()).isPresent();
        }

        public static boolean inServiceSpec(Cursor cursor) {
            return K8S.inMappingEntry("/spec", cursor);
        }

        public static boolean inExternalIPs(Cursor cursor) {
            return K8S.inMappingEntry("/spec/externalIPs", cursor);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Service)) {
                return false;
            }
            Service other = (Service)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Service;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Service(UUID id, String type) {
            this.id = id;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        public String getType() {
            return this.type;
        }

        public String toString() {
            return "K8S.Service(id=" + this.getId() + ", type=" + this.getType() + ")";
        }
    }

    public static class ResourceLimits
    implements K8S {
        private final UUID id;
        private final ResourceLimit value;

        public static boolean inLimits(String type, Cursor cursor) {
            return K8S.inMappingEntry("//spec/containers/resources/limits/" + type, cursor);
        }

        public static boolean inRequests(String type, Cursor cursor) {
            return K8S.inMappingEntry("//spec/containers/resources/requests/" + type, cursor);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResourceLimits)) {
                return false;
            }
            ResourceLimits other = (ResourceLimits)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ResourceLimits;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public ResourceLimits(UUID id, ResourceLimit value) {
            this.id = id;
            this.value = value;
        }

        public UUID getId() {
            return this.id;
        }

        public ResourceLimit getValue() {
            return this.value;
        }

        public String toString() {
            return "K8S.ResourceLimits(id=" + this.getId() + ", value=" + this.getValue() + ")";
        }
    }

    public static class InitContainers
    implements K8S {
        private final UUID id;

        public static boolean inInitContainerSpec(Cursor cursor) {
            return K8S.inMappingEntry("//spec/initContainers", cursor);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InitContainers)) {
                return false;
            }
            InitContainers other = (InitContainers)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InitContainers;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public InitContainers(UUID id) {
            this.id = id;
        }

        public UUID getId() {
            return this.id;
        }

        public String toString() {
            return "K8S.InitContainers(id=" + this.getId() + ")";
        }
    }

    public static class Containers
    implements K8S {
        private final UUID id;

        public static boolean inContainerSpec(Cursor cursor) {
            return K8S.inMappingEntry("//spec/containers", cursor);
        }

        public static boolean isImageName(Cursor cursor) {
            return K8S.firstEnclosingEntryMatching("//image", cursor).isPresent();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Containers)) {
                return false;
            }
            Containers other = (Containers)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Containers;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Containers(UUID id) {
            this.id = id;
        }

        public UUID getId() {
            return this.id;
        }

        public String toString() {
            return "K8S.Containers(id=" + this.getId() + ")";
        }
    }

    public static class Pod
    implements K8S {
        private final UUID id;

        public static boolean inSpec(Cursor cursor) {
            return K8S.inMappingEntry("//spec/*", cursor);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Pod)) {
                return false;
            }
            Pod other = (Pod)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Pod;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Pod(UUID id) {
            this.id = id;
        }

        public UUID getId() {
            return this.id;
        }

        public String toString() {
            return "K8S.Pod(id=" + this.getId() + ")";
        }
    }

    public static class Labels
    implements K8S {
        private final UUID id;
        private final Set<String> keys;

        public static boolean inLabels(Cursor cursor) {
            return K8S.inMappingEntry("//metadata/labels/*", cursor);
        }

        public boolean valueMatches(String name, Pattern regex, Cursor cursor) {
            Yaml.Mapping.Entry e;
            Yaml.Mapping.Entry entry = e = cursor.getValue() instanceof Yaml.Mapping.Entry ? (Yaml.Mapping.Entry)cursor.getValue() : (Yaml.Mapping.Entry)cursor.firstEnclosing(Yaml.Mapping.Entry.class);
            if (e == null) {
                return false;
            }
            if (!name.equals(e.getKey().getValue())) {
                return false;
            }
            if (!(e.getValue() instanceof Yaml.Scalar)) {
                return false;
            }
            String value = ((Yaml.Scalar)e.getValue()).getValue();
            return regex.matcher(value).matches();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Labels)) {
                return false;
            }
            Labels other = (Labels)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Labels;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Labels(UUID id, Set<String> keys) {
            this.id = id;
            this.keys = keys;
        }

        public UUID getId() {
            return this.id;
        }

        public Set<String> getKeys() {
            return this.keys;
        }

        public String toString() {
            return "K8S.Labels(id=" + this.getId() + ", keys=" + this.getKeys() + ")";
        }
    }

    public static class Annotations
    implements K8S {
        private final UUID id;
        private final Set<String> keys;

        public static boolean inAnnotations(Cursor cursor) {
            return K8S.inMappingEntry("//metadata/annotations/*", cursor);
        }

        public boolean valueMatches(String name, Pattern regex, Cursor cursor) {
            Yaml.Mapping.Entry e;
            Yaml.Mapping.Entry entry = e = cursor.getValue() instanceof Yaml.Mapping.Entry ? (Yaml.Mapping.Entry)cursor.getValue() : (Yaml.Mapping.Entry)cursor.firstEnclosing(Yaml.Mapping.Entry.class);
            if (e == null) {
                return false;
            }
            if (!name.equals(e.getKey().getValue())) {
                return false;
            }
            if (!(e.getValue() instanceof Yaml.Scalar)) {
                return false;
            }
            String value = ((Yaml.Scalar)e.getValue()).getValue();
            return regex.matcher(value).matches();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Annotations)) {
                return false;
            }
            Annotations other = (Annotations)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Annotations;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Annotations(UUID id, Set<String> keys) {
            this.id = id;
            this.keys = keys;
        }

        public UUID getId() {
            return this.id;
        }

        public Set<String> getKeys() {
            return this.keys;
        }

        public String toString() {
            return "K8S.Annotations(id=" + this.getId() + ", keys=" + this.getKeys() + ")";
        }
    }

    public static class Metadata
    implements K8S {
        private final UUID id;
        @Nullable
        private final String namespace;
        private final String name;

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Metadata)) {
                return false;
            }
            Metadata other = (Metadata)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Metadata;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Metadata(UUID id, String namespace, String name) {
            this.id = id;
            this.namespace = namespace;
            this.name = name;
        }

        public UUID getId() {
            return this.id;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "K8S.Metadata(id=" + this.getId() + ", namespace=" + this.getNamespace() + ", name=" + this.getName() + ")";
        }
    }

    public static class Resource
    implements K8S {
        private final UUID id;
        private final String apiVersion;
        private final String kind;

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Resource)) {
                return false;
            }
            Resource other = (Resource)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Resource;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Resource(UUID id, String apiVersion, String kind) {
            this.id = id;
            this.apiVersion = apiVersion;
            this.kind = kind;
        }

        public UUID getId() {
            return this.id;
        }

        public String getApiVersion() {
            return this.apiVersion;
        }

        public String getKind() {
            return this.kind;
        }

        public String toString() {
            return "K8S.Resource(id=" + this.getId() + ", apiVersion=" + this.getApiVersion() + ", kind=" + this.getKind() + ")";
        }
    }
}

