/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kubernetes.resource;

import java.beans.ConstructorProperties;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.HasSourcePath;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.kubernetes.resource.ResourceLimit;
import org.openrewrite.kubernetes.tree.K8S;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class CapResourceValueToMaximum
extends Recipe {
    @Option(displayName="Resource value type", description="The type of resource to search for.", example="limits", valid={"limits", "requests"})
    private final String resourceValueType;
    @Option(displayName="Resource type", description="The type of resource value to search for.", example="memory", valid={"cpu", "memory"})
    private final String resourceType;
    @Option(displayName="Resource limit", description="The resource maximum to search for to find resources that request more than the maximum.", example="2Gi")
    private final String resourceLimit;
    @Option(displayName="Optional file matcher", description="Matching files will be modified. This is a glob expression.", required=false, example="**/pod-*.yml")
    @Nullable
    private final String fileMatcher;

    public String getDisplayName() {
        return "Cap exceeds resource value";
    }

    public String getDescription() {
        return "Cap resource values that exceed a specific maximum.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        if (this.fileMatcher != null) {
            return new HasSourcePath(this.fileMatcher);
        }
        return null;
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        final ResourceLimit limit = new ResourceLimit(this.resourceLimit);
        return new YamlIsoVisitor<ExecutionContext>(){

            public Yaml.Scalar visitScalar(Yaml.Scalar scalar, ExecutionContext ctx) {
                Cursor c = this.getCursor();
                if ((K8S.ResourceLimits.inLimits(CapResourceValueToMaximum.this.resourceType, c) && "limits".equals(CapResourceValueToMaximum.this.resourceValueType) || K8S.ResourceLimits.inRequests(CapResourceValueToMaximum.this.resourceType, c) && "requests".equals(CapResourceValueToMaximum.this.resourceValueType)) && K8S.asResourceLimits(scalar).getValue().exceeds(limit.getValue())) {
                    return scalar.withValue(limit.convertToUnit(scalar));
                }
                return super.visitScalar(scalar, (Object)ctx);
            }
        };
    }

    @ConstructorProperties(value={"resourceValueType", "resourceType", "resourceLimit", "fileMatcher"})
    public CapResourceValueToMaximum(String resourceValueType, String resourceType, String resourceLimit, @Nullable String fileMatcher) {
        this.resourceValueType = resourceValueType;
        this.resourceType = resourceType;
        this.resourceLimit = resourceLimit;
        this.fileMatcher = fileMatcher;
    }

    public String getResourceValueType() {
        return this.resourceValueType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getResourceLimit() {
        return this.resourceLimit;
    }

    @Nullable
    public String getFileMatcher() {
        return this.fileMatcher;
    }

    @NonNull
    public String toString() {
        return "CapResourceValueToMaximum(resourceValueType=" + this.getResourceValueType() + ", resourceType=" + this.getResourceType() + ", resourceLimit=" + this.getResourceLimit() + ", fileMatcher=" + this.getFileMatcher() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CapResourceValueToMaximum)) {
            return false;
        }
        CapResourceValueToMaximum other = (CapResourceValueToMaximum)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$resourceValueType = this.getResourceValueType();
        String other$resourceValueType = other.getResourceValueType();
        if (this$resourceValueType == null ? other$resourceValueType != null : !this$resourceValueType.equals(other$resourceValueType)) {
            return false;
        }
        String this$resourceType = this.getResourceType();
        String other$resourceType = other.getResourceType();
        if (this$resourceType == null ? other$resourceType != null : !this$resourceType.equals(other$resourceType)) {
            return false;
        }
        String this$resourceLimit = this.getResourceLimit();
        String other$resourceLimit = other.getResourceLimit();
        if (this$resourceLimit == null ? other$resourceLimit != null : !this$resourceLimit.equals(other$resourceLimit)) {
            return false;
        }
        String this$fileMatcher = this.getFileMatcher();
        String other$fileMatcher = other.getFileMatcher();
        return !(this$fileMatcher == null ? other$fileMatcher != null : !this$fileMatcher.equals(other$fileMatcher));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof CapResourceValueToMaximum;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $resourceValueType = this.getResourceValueType();
        result = result * 59 + ($resourceValueType == null ? 43 : $resourceValueType.hashCode());
        String $resourceType = this.getResourceType();
        result = result * 59 + ($resourceType == null ? 43 : $resourceType.hashCode());
        String $resourceLimit = this.getResourceLimit();
        result = result * 59 + ($resourceLimit == null ? 43 : $resourceLimit.hashCode());
        String $fileMatcher = this.getFileMatcher();
        result = result * 59 + ($fileMatcher == null ? 43 : $fileMatcher.hashCode());
        return result;
    }
}

