/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kubernetes.resource;

import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.kubernetes.resource.ResourceLimit;
import org.openrewrite.kubernetes.tree.K8S;
import org.openrewrite.marker.Marker;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.search.YamlSearchResult;
import org.openrewrite.yaml.tree.Yaml;

public final class FindExceedsResourceRatio
extends Recipe {
    @Option(displayName="Resource limit type", description="The type of resource limit to search for.", example="memory", valid={"cpu", "memory"})
    private final String resourceType;
    @Option(displayName="Resource ratio", description="The maximum ratio allowed between requests and limits.", example="2")
    private final String ratioLimit;

    public String getDisplayName() {
        return "Find exceeds resource ratio";
    }

    public String getDescription() {
        return "Find resource manifests that have requests to limits ratios beyond a specific maximum.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        final YamlSearchResult result = new YamlSearchResult(Tree.randomId(), (Recipe)this, "exceeds max " + this.resourceType + " limits/requests ratio of " + this.ratioLimit);
        final int resourceLimit = Integer.parseInt(this.ratioLimit);
        return new YamlIsoVisitor<ExecutionContext>(){

            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext executionContext) {
                Yaml.Mapping.Entry e = super.visitMappingEntry(entry, (Object)executionContext);
                Cursor c = this.getCursor();
                if (K8S.ResourceLimits.inResources(c)) {
                    JsonPathMatcher requestsMatcher = new JsonPathMatcher(".requests." + FindExceedsResourceRatio.this.resourceType);
                    JsonPathMatcher limitsMatcher = new JsonPathMatcher(".limits." + FindExceedsResourceRatio.this.resourceType);
                    return requestsMatcher.find(c).flatMap(req -> limitsMatcher.find(c).map(lim -> {
                        String reqValStr = FindExceedsResourceRatio.valueFromEntry(req);
                        if (reqValStr == null) {
                            return e;
                        }
                        ResourceLimit reqLimit = new ResourceLimit(reqValStr);
                        String limValStr = FindExceedsResourceRatio.valueFromEntry(lim);
                        if (limValStr == null) {
                            return e;
                        }
                        ResourceLimit limLimit = new ResourceLimit(limValStr);
                        if (reqLimit.exceedsRatio(resourceLimit, limLimit.getValue())) {
                            return e.withMarkers(e.getMarkers().addIfAbsent((Marker)result));
                        }
                        return e;
                    })).orElse(e);
                }
                return e;
            }
        };
    }

    @Nullable
    private static String valueFromEntry(Object o) {
        if (!(o instanceof Yaml.Mapping.Entry)) {
            return null;
        }
        Yaml.Mapping.Entry e = (Yaml.Mapping.Entry)o;
        if (!(e.getValue() instanceof Yaml.Scalar)) {
            return null;
        }
        Yaml.Scalar s = (Yaml.Scalar)e.getValue();
        return s.getValue();
    }

    public FindExceedsResourceRatio(String resourceType, String ratioLimit) {
        this.resourceType = resourceType;
        this.ratioLimit = ratioLimit;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getRatioLimit() {
        return this.ratioLimit;
    }

    public String toString() {
        return "FindExceedsResourceRatio(resourceType=" + this.getResourceType() + ", ratioLimit=" + this.getRatioLimit() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindExceedsResourceRatio)) {
            return false;
        }
        FindExceedsResourceRatio other = (FindExceedsResourceRatio)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$resourceType = this.getResourceType();
        String other$resourceType = other.getResourceType();
        if (this$resourceType == null ? other$resourceType != null : !this$resourceType.equals(other$resourceType)) {
            return false;
        }
        String this$ratioLimit = this.getRatioLimit();
        String other$ratioLimit = other.getRatioLimit();
        return !(this$ratioLimit == null ? other$ratioLimit != null : !this$ratioLimit.equals(other$ratioLimit));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FindExceedsResourceRatio;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $resourceType = this.getResourceType();
        result = result * 59 + ($resourceType == null ? 43 : $resourceType.hashCode());
        String $ratioLimit = this.getRatioLimit();
        result = result * 59 + ($ratioLimit == null ? 43 : $ratioLimit.hashCode());
        return result;
    }
}

