/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kubernetes.resource;

import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.kubernetes.resource.ResourceLimit;
import org.openrewrite.kubernetes.tree.K8S;
import org.openrewrite.marker.Marker;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.search.YamlSearchResult;
import org.openrewrite.yaml.tree.Yaml;

public final class FindExceedsResourceValue
extends Recipe {
    @Option(displayName="Resource value type", description="The type of resource value to search for.", example="limits", valid={"limits", "requests"})
    private final String resourceValueType;
    @Option(displayName="Resource limit type", description="The type of resource limit to search for.", example="memory", valid={"cpu", "memory"})
    private final String resourceType;
    @Option(displayName="Resource limit", description="The resource limit maximum to search for to find resources that request more than the maximum.", example="2Gi")
    private final String resourceLimit;

    public String getDisplayName() {
        return "Find exceeds resource limit";
    }

    public String getDescription() {
        return "Find resource manifests that have limits set beyond a specific maximum.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        final ResourceLimit limit = new ResourceLimit(this.resourceLimit);
        final YamlSearchResult result = new YamlSearchResult(Tree.randomId(), (Recipe)this, "exceeds maximum of " + limit.getValue());
        return new YamlIsoVisitor<ExecutionContext>(){

            public Yaml.Scalar visitScalar(Yaml.Scalar scalar, ExecutionContext executionContext) {
                Cursor c = this.getCursor();
                if ((K8S.ResourceLimits.inLimits(FindExceedsResourceValue.this.resourceType, c) && "limits".equals(FindExceedsResourceValue.this.resourceValueType) || K8S.ResourceLimits.inRequests(FindExceedsResourceValue.this.resourceType, c) && "requests".equals(FindExceedsResourceValue.this.resourceValueType)) && K8S.asResourceLimits(scalar).getValue().exceeds(limit.getValue())) {
                    return scalar.withMarkers(scalar.getMarkers().addIfAbsent((Marker)result));
                }
                return super.visitScalar(scalar, (Object)executionContext);
            }
        };
    }

    public FindExceedsResourceValue(String resourceValueType, String resourceType, String resourceLimit) {
        this.resourceValueType = resourceValueType;
        this.resourceType = resourceType;
        this.resourceLimit = resourceLimit;
    }

    public String getResourceValueType() {
        return this.resourceValueType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getResourceLimit() {
        return this.resourceLimit;
    }

    public String toString() {
        return "FindExceedsResourceValue(resourceValueType=" + this.getResourceValueType() + ", resourceType=" + this.getResourceType() + ", resourceLimit=" + this.getResourceLimit() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindExceedsResourceValue)) {
            return false;
        }
        FindExceedsResourceValue other = (FindExceedsResourceValue)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$resourceValueType = this.getResourceValueType();
        String other$resourceValueType = other.getResourceValueType();
        if (this$resourceValueType == null ? other$resourceValueType != null : !this$resourceValueType.equals(other$resourceValueType)) {
            return false;
        }
        String this$resourceType = this.getResourceType();
        String other$resourceType = other.getResourceType();
        if (this$resourceType == null ? other$resourceType != null : !this$resourceType.equals(other$resourceType)) {
            return false;
        }
        String this$resourceLimit = this.getResourceLimit();
        String other$resourceLimit = other.getResourceLimit();
        return !(this$resourceLimit == null ? other$resourceLimit != null : !this$resourceLimit.equals(other$resourceLimit));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FindExceedsResourceValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $resourceValueType = this.getResourceValueType();
        result = result * 59 + ($resourceValueType == null ? 43 : $resourceValueType.hashCode());
        String $resourceType = this.getResourceType();
        result = result * 59 + ($resourceType == null ? 43 : $resourceType.hashCode());
        String $resourceLimit = this.getResourceLimit();
        result = result * 59 + ($resourceLimit == null ? 43 : $resourceLimit.hashCode());
        return result;
    }
}

