/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kubernetes.resource;

import java.util.Locale;
import org.openrewrite.yaml.tree.Yaml;

public class ResourceLimit {
    private final ResourceValue value;

    public ResourceLimit(String value) {
        this.value = new ResourceValue(value);
    }

    public String convertToUnit(Yaml.Scalar scalar) {
        ResourceValue rv = new ResourceValue(scalar.getValue());
        return this.value.convertTo(rv.getUnit()).toString();
    }

    public ResourceValue getValue() {
        return this.value;
    }

    public boolean exceeds(ResourceValue rv) {
        return this.value.getAbsoluteValue() > rv.getAbsoluteValue();
    }

    public boolean exceedsRatio(int ratio, ResourceValue rv) {
        return (double)rv.getAbsoluteValue() / (double)this.value.getAbsoluteValue() > (double)ratio;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourceLimit)) {
            return false;
        }
        ResourceLimit other = (ResourceLimit)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResourceValue this$value = this.getValue();
        ResourceValue other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResourceLimit;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResourceValue $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public static class ResourceValue {
        private final Unit unit;
        private final long value;

        public ResourceValue(String resourceLimit) {
            int unitLen = 1;
            if (resourceLimit.endsWith("i")) {
                unitLen = 2;
            }
            this.unit = Unit.fromString(resourceLimit.substring(resourceLimit.length() - unitLen));
            this.value = this.unit.toAbsoluteValue(Long.parseLong(resourceLimit.substring(0, resourceLimit.length() - unitLen)));
        }

        public ResourceValue(long value, Unit unit) {
            this.value = value;
            this.unit = unit;
        }

        public long getAbsoluteValue() {
            return this.value;
        }

        public ResourceValue convertTo(Unit destUnit) {
            return new ResourceValue(this.value, destUnit);
        }

        public Unit getUnit() {
            return this.unit;
        }

        public String toString() {
            return this.unit.fromAbsoluteValue(this.value) + this.unit.toString();
        }

        public static enum Unit {
            K,
            M,
            G,
            T,
            P,
            Ki,
            Mi,
            Gi,
            Ti,
            Pi;


            public String toString() {
                return this == K ? "k" : super.toString();
            }

            public static Unit fromString(String s) {
                switch (s.toLowerCase(Locale.ROOT)) {
                    case "k": {
                        return K;
                    }
                    case "m": {
                        return M;
                    }
                    case "g": {
                        return G;
                    }
                    case "t": {
                        return T;
                    }
                    case "p": {
                        return P;
                    }
                    case "ki": {
                        return Ki;
                    }
                    case "mi": {
                        return Mi;
                    }
                    case "gi": {
                        return Gi;
                    }
                    case "ti": {
                        return Ti;
                    }
                    case "pi": {
                        return Pi;
                    }
                }
                return M;
            }

            public long fromAbsoluteValue(long absoluteValue) {
                switch (this) {
                    case M: {
                        return (long)((double)absoluteValue / Math.pow(1000.0, 2.0));
                    }
                    case G: {
                        return (long)((double)absoluteValue / Math.pow(1000.0, 3.0));
                    }
                    case T: {
                        return (long)((double)absoluteValue / Math.pow(1000.0, 4.0));
                    }
                    case P: {
                        return (long)((double)absoluteValue / Math.pow(1000.0, 5.0));
                    }
                    case Ki: {
                        return absoluteValue / 1024L;
                    }
                    case Mi: {
                        return (long)((double)absoluteValue / Math.pow(1024.0, 2.0));
                    }
                    case Gi: {
                        return (long)((double)absoluteValue / Math.pow(1024.0, 3.0));
                    }
                    case Ti: {
                        return (long)((double)absoluteValue / Math.pow(1024.0, 4.0));
                    }
                    case Pi: {
                        return (long)((double)absoluteValue / Math.pow(1024.0, 5.0));
                    }
                }
                return absoluteValue / 1000L;
            }

            public long toAbsoluteValue(long relativeValue) {
                switch (this) {
                    case M: {
                        return (long)((double)relativeValue * Math.pow(1000.0, 2.0));
                    }
                    case G: {
                        return (long)((double)relativeValue * Math.pow(1000.0, 3.0));
                    }
                    case T: {
                        return (long)((double)relativeValue * Math.pow(1000.0, 4.0));
                    }
                    case P: {
                        return (long)((double)relativeValue * Math.pow(1000.0, 5.0));
                    }
                    case Ki: {
                        return relativeValue * 1024L;
                    }
                    case Mi: {
                        return (long)((double)relativeValue * Math.pow(1024.0, 2.0));
                    }
                    case Gi: {
                        return (long)((double)relativeValue * Math.pow(1024.0, 3.0));
                    }
                    case Ti: {
                        return (long)((double)relativeValue * Math.pow(1024.0, 4.0));
                    }
                    case Pi: {
                        return (long)((double)relativeValue * Math.pow(1024.0, 5.0));
                    }
                }
                return relativeValue * 1000L;
            }
        }
    }
}

