/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kubernetes.search;

import java.util.regex.Pattern;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.kubernetes.search.EntryMarkingVisitor;
import org.openrewrite.kubernetes.tree.K8S;
import org.openrewrite.yaml.search.YamlSearchResult;
import org.openrewrite.yaml.tree.Yaml;

public final class FindMissingOrInvalidAnnotation
extends Recipe {
    @Option(displayName="Annotation name", description="The name of the annotation to search for the existence of.", example="mycompany.io/annotation")
    private final String annotationName;
    @Option(displayName="Value", description="An optional regex that will validate values that match.", example="value.*", required=false)
    @Nullable
    private final String value;

    public String getDisplayName() {
        return "Find annotation";
    }

    public String getDescription() {
        return "Find annotations that optionally match a given value.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        final Pattern pattern = this.value != null ? Pattern.compile(this.value) : null;
        final YamlSearchResult missing = new YamlSearchResult((Recipe)this, "missing:" + this.annotationName);
        final YamlSearchResult invalid = null != this.value ? new YamlSearchResult((Recipe)this, "invalid:" + this.value) : null;
        return new EntryMarkingVisitor(){

            @Override
            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                Cursor c = this.getCursor();
                if (K8S.Annotations.inAnnotations(c)) {
                    K8S.Annotations annos = K8S.asAnnotations((Yaml.Mapping)c.firstEnclosing(Yaml.Mapping.class));
                    if (FindMissingOrInvalidAnnotation.this.value == null && !annos.getKeys().contains(FindMissingOrInvalidAnnotation.this.annotationName)) {
                        c.getParentOrThrow().putMessageOnFirstEnclosing(Yaml.Mapping.Entry.class, MARKER, (Object)missing);
                    } else if (pattern != null && !annos.valueMatches(FindMissingOrInvalidAnnotation.this.annotationName, pattern, c)) {
                        c.putMessageOnFirstEnclosing(Yaml.Mapping.Entry.class, MARKER, (Object)invalid);
                    }
                }
                return super.visitMappingEntry(entry, ctx);
            }
        };
    }

    public FindMissingOrInvalidAnnotation(String annotationName, String value) {
        this.annotationName = annotationName;
        this.value = value;
    }

    public String getAnnotationName() {
        return this.annotationName;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return "FindMissingOrInvalidAnnotation(annotationName=" + this.getAnnotationName() + ", value=" + this.getValue() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindMissingOrInvalidAnnotation)) {
            return false;
        }
        FindMissingOrInvalidAnnotation other = (FindMissingOrInvalidAnnotation)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$annotationName = this.getAnnotationName();
        String other$annotationName = other.getAnnotationName();
        if (this$annotationName == null ? other$annotationName != null : !this$annotationName.equals(other$annotationName)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FindMissingOrInvalidAnnotation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $annotationName = this.getAnnotationName();
        result = result * 59 + ($annotationName == null ? 43 : $annotationName.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}

