/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kubernetes.search;

import java.util.regex.Pattern;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.HasSourcePath;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.kubernetes.search.EntryMarkingVisitor;
import org.openrewrite.kubernetes.tree.K8S;
import org.openrewrite.yaml.search.YamlSearchResult;
import org.openrewrite.yaml.tree.Yaml;

public final class FindMissingOrInvalidLabel
extends Recipe {
    @Option(displayName="Label name", description="The name of the label to search for the existence of.", example="mylabel")
    private final String labelName;
    @Option(displayName="Value", description="An optional regex that will validate values that match.", example="value(.*)", required=false)
    @Nullable
    private final String value;
    @Option(displayName="Optional file matcher", description="Matching files will be modified. This is a glob expression.", required=false, example="**/pod-*.yml")
    @Nullable
    private final String fileMatcher;

    public String getDisplayName() {
        return "Find label";
    }

    public String getDescription() {
        return "Find labels that optionally match a given regex.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        if (this.fileMatcher != null) {
            return new HasSourcePath(this.fileMatcher);
        }
        return null;
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        final Pattern pattern = this.value != null ? Pattern.compile(this.value) : null;
        final YamlSearchResult missing = new YamlSearchResult((Recipe)this, "missing:" + this.labelName);
        final YamlSearchResult invalid = null != this.value ? new YamlSearchResult((Recipe)this, "invalid:" + this.value) : null;
        return new EntryMarkingVisitor(){

            @Override
            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                Cursor c = this.getCursor();
                if (K8S.Labels.inLabels(c)) {
                    K8S.Labels labels = K8S.asLabels((Yaml.Mapping)c.firstEnclosing(Yaml.Mapping.class));
                    if (FindMissingOrInvalidLabel.this.value == null && !labels.getKeys().contains(FindMissingOrInvalidLabel.this.labelName)) {
                        c.getParentOrThrow().putMessageOnFirstEnclosing(Yaml.Mapping.Entry.class, MARKER, (Object)missing);
                    } else if (pattern != null && !labels.valueMatches(FindMissingOrInvalidLabel.this.labelName, pattern, c)) {
                        c.putMessageOnFirstEnclosing(Yaml.Mapping.Entry.class, MARKER, (Object)invalid);
                    }
                }
                return super.visitMappingEntry(entry, ctx);
            }
        };
    }

    public FindMissingOrInvalidLabel(String labelName, String value, String fileMatcher) {
        this.labelName = labelName;
        this.value = value;
        this.fileMatcher = fileMatcher;
    }

    public String getLabelName() {
        return this.labelName;
    }

    public String getValue() {
        return this.value;
    }

    public String getFileMatcher() {
        return this.fileMatcher;
    }

    public String toString() {
        return "FindMissingOrInvalidLabel(labelName=" + this.getLabelName() + ", value=" + this.getValue() + ", fileMatcher=" + this.getFileMatcher() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindMissingOrInvalidLabel)) {
            return false;
        }
        FindMissingOrInvalidLabel other = (FindMissingOrInvalidLabel)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$labelName = this.getLabelName();
        String other$labelName = other.getLabelName();
        if (this$labelName == null ? other$labelName != null : !this$labelName.equals(other$labelName)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$fileMatcher = this.getFileMatcher();
        String other$fileMatcher = other.getFileMatcher();
        return !(this$fileMatcher == null ? other$fileMatcher != null : !this$fileMatcher.equals(other$fileMatcher));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FindMissingOrInvalidLabel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $labelName = this.getLabelName();
        result = result * 59 + ($labelName == null ? 43 : $labelName.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $fileMatcher = this.getFileMatcher();
        result = result * 59 + ($fileMatcher == null ? 43 : $fileMatcher.hashCode());
        return result;
    }
}

