/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kubernetes.search;

import org.openrewrite.ExecutionContext;
import org.openrewrite.HasSourcePath;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.kubernetes.tree.K8S;
import org.openrewrite.marker.Marker;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.search.YamlSearchResult;
import org.openrewrite.yaml.tree.Yaml;

public class FindNonTlsIngress
extends Recipe {
    @Option(displayName="Optional file matcher", description="Matching files will be modified. This is a glob expression.", required=false, example="**/pod-*.yml")
    @Nullable
    String fileMatcher;

    public String getDisplayName() {
        return "Find non-TLS Ingresses";
    }

    public String getDescription() {
        return "Find Ingress resources that don't disallow HTTP or don't have TLS configured.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        if (this.fileMatcher != null) {
            return new HasSourcePath(this.fileMatcher);
        }
        return null;
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        final YamlSearchResult missingTls = new YamlSearchResult((Recipe)this, "missing TLS");
        final YamlSearchResult missingDisallowHttp = new YamlSearchResult((Recipe)this, "missing disallow http");
        return new YamlIsoVisitor<ExecutionContext>(){

            public Yaml.Document visitDocument(Yaml.Document document, ExecutionContext ctx) {
                if (K8S.inKind("Ingress", this.getCursor())) {
                    Yaml.Document d = super.visitDocument(document, (Object)ctx);
                    if (!K8S.Ingress.isTlsConfigured(this.getCursor())) {
                        d = d.withMarkers(d.getMarkers().addIfAbsent((Marker)missingTls));
                    }
                    if (!K8S.Ingress.isDisallowHttpConfigured(this.getCursor())) {
                        d = d.withMarkers(d.getMarkers().addIfAbsent((Marker)missingDisallowHttp));
                    }
                    return d;
                }
                return super.visitDocument(document, (Object)ctx);
            }
        };
    }
}

