/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kubernetes.rbac;

import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.HasSourcePath;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.kubernetes.tree.K8S;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.YamlParser;
import org.openrewrite.yaml.tree.Yaml;

public final class AddRuleToRole
extends Recipe {
    @Option(displayName="RBAC Resource type", description="Type of RBAC resource to which this recipe adds a rule.", example="ClusterRole", valid={"ClusterRole", "Role"})
    private final String rbacResourceType;
    @Option(displayName="RBAC Resource name", description="Glob pattern of the name of the RBAC resource to which this recipe adds a rule.", example="my-cluster-role")
    private final String rbacResourceName;
    @Option(displayName="API groups", description="Comma-separated list of API groups to which this rule refers.", example=",v1")
    private final Set<String> apiGroups;
    @Option(displayName="Resource types", description="Comma-separated list of Kubernetes resource types to which this rule refers.", example="pods")
    private final Set<String> resources;
    @Option(displayName="Resource names", description="Comma-separated list of names of Kubernetes resources to which this rule applies.", example="my-pod", required=false)
    @Nullable
    private final Set<String> resourceNames;
    @Option(displayName="API verbs", description="The API verbs to enable with this rule.", example="get,list")
    private final Set<String> verbs;
    @Option(displayName="Optional file matcher", description="Matching files will be modified. This is a glob expression.", required=false, example="**/pod-*.yml")
    @Nullable
    private final String fileMatcher;
    @Nullable
    private final Yaml.Sequence.Entry newSequenceEntry;

    public AddRuleToRole(String rbacResourceType, String rbacResourceName, Set<String> apiGroups, Set<String> resources, @Nullable Set<String> resourceNames, Set<String> verbs, @Nullable String fileMatcher) {
        this.rbacResourceType = rbacResourceType;
        this.rbacResourceName = rbacResourceName;
        this.apiGroups = apiGroups;
        this.resources = resources;
        this.resourceNames = resourceNames;
        this.verbs = verbs;
        this.fileMatcher = fileMatcher;
        String apiGroupsStr = AddRuleToRole.setToString(apiGroups);
        String resourcesStr = AddRuleToRole.setToString(resources);
        String resourceNamesStr = AddRuleToRole.setToString(resourceNames);
        String verbsStr = AddRuleToRole.setToString(verbs);
        List docs = new YamlParser().parse(new String[]{"- apiGroups: " + apiGroupsStr + "\n  resources: " + resourcesStr + "\n" + (resourceNamesStr != null ? "  resourceNames: " + resourceNamesStr + "\n" : "") + "  verbs: " + verbsStr});
        this.newSequenceEntry = ((Yaml.Sequence.Entry)((Yaml.Sequence)((Yaml.Document)((Yaml.Documents)docs.get(0)).getDocuments().get(0)).getBlock()).getEntries().get(0)).withPrefix("\n");
    }

    public String getDisplayName() {
        return "Add RBAC rules";
    }

    public String getDescription() {
        return "Add RBAC rules to ClusterRoles or namespaced Roles.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        if (this.fileMatcher != null) {
            return new HasSourcePath(this.fileMatcher);
        }
        return null;
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        final PathMatcher globMatcher = FileSystems.getDefault().getPathMatcher("glob:" + this.rbacResourceName);
        return new YamlIsoVisitor<ExecutionContext>(){

            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext executionContext) {
                K8S.Metadata meta;
                Cursor c = this.getCursor();
                if (K8S.inKind(AddRuleToRole.this.rbacResourceType, c) && K8S.Metadata.isMetadata(c) && globMatcher.matches(Paths.get((meta = K8S.asMetadata((Yaml.Mapping)entry.getValue())).getName(), new String[0]))) {
                    c.putMessageOnFirstEnclosing(Yaml.Document.class, "resource-name", (Object)meta.getName());
                }
                return super.visitMappingEntry(entry, (Object)executionContext);
            }

            public Yaml.Sequence visitSequence(Yaml.Sequence sequence, ExecutionContext executionContext) {
                Yaml.Sequence s = super.visitSequence(sequence, (Object)executionContext);
                Cursor c = this.getCursor();
                if (K8S.RBAC.inRules(c) && c.getNearestMessage("resource-name") != null && !s.getEntries().contains(AddRuleToRole.this.newSequenceEntry)) {
                    return s.withEntries(ListUtils.concat((List)s.getEntries(), (Object)AddRuleToRole.this.newSequenceEntry));
                }
                return s;
            }
        };
    }

    @Nullable
    private static String setToString(@Nullable Set<String> strs) {
        if (strs == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean needsComma = false;
        for (String s : strs) {
            if (needsComma) {
                sb.append(", ");
            } else {
                needsComma = true;
            }
            sb.append("\"").append(s).append("\"");
        }
        sb.append("]");
        return sb.toString();
    }

    public String getRbacResourceType() {
        return this.rbacResourceType;
    }

    public String getRbacResourceName() {
        return this.rbacResourceName;
    }

    public Set<String> getApiGroups() {
        return this.apiGroups;
    }

    public Set<String> getResources() {
        return this.resources;
    }

    public Set<String> getResourceNames() {
        return this.resourceNames;
    }

    public Set<String> getVerbs() {
        return this.verbs;
    }

    public String getFileMatcher() {
        return this.fileMatcher;
    }

    public Yaml.Sequence.Entry getNewSequenceEntry() {
        return this.newSequenceEntry;
    }

    public String toString() {
        return "AddRuleToRole(rbacResourceType=" + this.getRbacResourceType() + ", rbacResourceName=" + this.getRbacResourceName() + ", apiGroups=" + this.getApiGroups() + ", resources=" + this.getResources() + ", resourceNames=" + this.getResourceNames() + ", verbs=" + this.getVerbs() + ", fileMatcher=" + this.getFileMatcher() + ", newSequenceEntry=" + this.getNewSequenceEntry() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddRuleToRole)) {
            return false;
        }
        AddRuleToRole other = (AddRuleToRole)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$rbacResourceType = this.getRbacResourceType();
        String other$rbacResourceType = other.getRbacResourceType();
        if (this$rbacResourceType == null ? other$rbacResourceType != null : !this$rbacResourceType.equals(other$rbacResourceType)) {
            return false;
        }
        String this$rbacResourceName = this.getRbacResourceName();
        String other$rbacResourceName = other.getRbacResourceName();
        if (this$rbacResourceName == null ? other$rbacResourceName != null : !this$rbacResourceName.equals(other$rbacResourceName)) {
            return false;
        }
        Set<String> this$apiGroups = this.getApiGroups();
        Set<String> other$apiGroups = other.getApiGroups();
        if (this$apiGroups == null ? other$apiGroups != null : !((Object)this$apiGroups).equals(other$apiGroups)) {
            return false;
        }
        Set<String> this$resources = this.getResources();
        Set<String> other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
            return false;
        }
        Set<String> this$resourceNames = this.getResourceNames();
        Set<String> other$resourceNames = other.getResourceNames();
        if (this$resourceNames == null ? other$resourceNames != null : !((Object)this$resourceNames).equals(other$resourceNames)) {
            return false;
        }
        Set<String> this$verbs = this.getVerbs();
        Set<String> other$verbs = other.getVerbs();
        if (this$verbs == null ? other$verbs != null : !((Object)this$verbs).equals(other$verbs)) {
            return false;
        }
        String this$fileMatcher = this.getFileMatcher();
        String other$fileMatcher = other.getFileMatcher();
        if (this$fileMatcher == null ? other$fileMatcher != null : !this$fileMatcher.equals(other$fileMatcher)) {
            return false;
        }
        Yaml.Sequence.Entry this$newSequenceEntry = this.getNewSequenceEntry();
        Yaml.Sequence.Entry other$newSequenceEntry = other.getNewSequenceEntry();
        return !(this$newSequenceEntry == null ? other$newSequenceEntry != null : !this$newSequenceEntry.equals(other$newSequenceEntry));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AddRuleToRole;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $rbacResourceType = this.getRbacResourceType();
        result = result * 59 + ($rbacResourceType == null ? 43 : $rbacResourceType.hashCode());
        String $rbacResourceName = this.getRbacResourceName();
        result = result * 59 + ($rbacResourceName == null ? 43 : $rbacResourceName.hashCode());
        Set<String> $apiGroups = this.getApiGroups();
        result = result * 59 + ($apiGroups == null ? 43 : ((Object)$apiGroups).hashCode());
        Set<String> $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
        Set<String> $resourceNames = this.getResourceNames();
        result = result * 59 + ($resourceNames == null ? 43 : ((Object)$resourceNames).hashCode());
        Set<String> $verbs = this.getVerbs();
        result = result * 59 + ($verbs == null ? 43 : ((Object)$verbs).hashCode());
        String $fileMatcher = this.getFileMatcher();
        result = result * 59 + ($fileMatcher == null ? 43 : $fileMatcher.hashCode());
        Yaml.Sequence.Entry $newSequenceEntry = this.getNewSequenceEntry();
        result = result * 59 + ($newSequenceEntry == null ? 43 : $newSequenceEntry.hashCode());
        return result;
    }
}

