/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kubernetes.search;

import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.HasSourcePath;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.kubernetes.ContainerImage;
import org.openrewrite.kubernetes.tree.K8S;
import org.openrewrite.marker.Marker;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.search.YamlSearchResult;
import org.openrewrite.yaml.tree.Yaml;

public final class FindDisallowedImageTags
extends Recipe {
    @Option(displayName="Disallowed tags", description="The set of image tags to find which are considered disallowed.", example="latest")
    private final Set<String> disallowedTags;
    @Option(displayName="Include initContainers", description="Boolean to indicate whether or not to treat initContainers/image identically to containers/image.", example="false", required=false)
    private final boolean includeInitContainers;
    @Option(displayName="Optional file matcher", description="Matching files will be modified. This is a glob expression.", required=false, example="**/pod-*.yml")
    @Nullable
    private final String fileMatcher;

    public String getDisplayName() {
        return "Disallowed tags";
    }

    public String getDescription() {
        return "The set of image tags to find which are considered disallowed.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        if (this.fileMatcher != null) {
            return new HasSourcePath(this.fileMatcher);
        }
        return null;
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        final YamlSearchResult result = new YamlSearchResult((Recipe)this, "disallowed tag: " + this.disallowedTags);
        return new YamlIsoVisitor<ExecutionContext>(){

            public Yaml.Scalar visitScalar(Yaml.Scalar scalar, ExecutionContext ctx) {
                Cursor c = this.getCursor();
                if ((K8S.Containers.inContainerSpec(c) || FindDisallowedImageTags.this.includeInitContainers && K8S.InitContainers.inInitContainerSpec(c)) && K8S.Containers.isImageName(c)) {
                    ContainerImage image = new ContainerImage(scalar);
                    if (FindDisallowedImageTags.this.disallowedTags.stream().anyMatch(t -> t.equals(image.getImageName().getTag()))) {
                        return scalar.withMarkers(scalar.getMarkers().addIfAbsent((Marker)result));
                    }
                }
                return super.visitScalar(scalar, (Object)ctx);
            }
        };
    }

    public FindDisallowedImageTags(Set<String> disallowedTags, boolean includeInitContainers, String fileMatcher) {
        this.disallowedTags = disallowedTags;
        this.includeInitContainers = includeInitContainers;
        this.fileMatcher = fileMatcher;
    }

    public Set<String> getDisallowedTags() {
        return this.disallowedTags;
    }

    public boolean isIncludeInitContainers() {
        return this.includeInitContainers;
    }

    public String getFileMatcher() {
        return this.fileMatcher;
    }

    public String toString() {
        return "FindDisallowedImageTags(disallowedTags=" + this.getDisallowedTags() + ", includeInitContainers=" + this.isIncludeInitContainers() + ", fileMatcher=" + this.getFileMatcher() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindDisallowedImageTags)) {
            return false;
        }
        FindDisallowedImageTags other = (FindDisallowedImageTags)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isIncludeInitContainers() != other.isIncludeInitContainers()) {
            return false;
        }
        Set<String> this$disallowedTags = this.getDisallowedTags();
        Set<String> other$disallowedTags = other.getDisallowedTags();
        if (this$disallowedTags == null ? other$disallowedTags != null : !((Object)this$disallowedTags).equals(other$disallowedTags)) {
            return false;
        }
        String this$fileMatcher = this.getFileMatcher();
        String other$fileMatcher = other.getFileMatcher();
        return !(this$fileMatcher == null ? other$fileMatcher != null : !this$fileMatcher.equals(other$fileMatcher));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FindDisallowedImageTags;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isIncludeInitContainers() ? 79 : 97);
        Set<String> $disallowedTags = this.getDisallowedTags();
        result = result * 59 + ($disallowedTags == null ? 43 : ((Object)$disallowedTags).hashCode());
        String $fileMatcher = this.getFileMatcher();
        result = result * 59 + ($fileMatcher == null ? 43 : $fileMatcher.hashCode());
        return result;
    }
}

