/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kubernetes.tree;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.kubernetes.resource.ResourceLimit;
import org.openrewrite.marker.Marker;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.tree.Yaml;

public interface K8S
extends Marker {
    public static boolean inKind(String kind, Cursor cursor) {
        Yaml.Document doc = (Yaml.Document)cursor.firstEnclosing(Yaml.Document.class);
        if (doc == null) {
            return false;
        }
        Resource r = K8S.asResource((Yaml.Mapping)doc.getBlock());
        return kind.equals(r.getKind());
    }

    public static boolean inPod(Cursor cursor) {
        return K8S.inKind("Pod", cursor);
    }

    public static boolean inDaemonSet(Cursor cursor) {
        return K8S.inKind("DaemonSet", cursor);
    }

    public static boolean inStatefulSet(Cursor cursor) {
        return K8S.inKind("StatefulSet", cursor);
    }

    public static boolean inDeployment(Cursor cursor) {
        return K8S.inKind("Deployment", cursor);
    }

    public static boolean inService(Cursor cursor) {
        return K8S.inKind("Service", cursor);
    }

    public static Resource asResource(Yaml.Mapping m) {
        String apiVersion = null;
        String kind = null;
        for (Yaml.Mapping.Entry e : m.getEntries()) {
            Yaml.Block value = e.getValue();
            switch (e.getKey().getValue()) {
                case "apiVersion": {
                    apiVersion = ((Yaml.Scalar)value).getValue();
                    break;
                }
                case "kind": {
                    kind = ((Yaml.Scalar)value).getValue();
                }
            }
        }
        return new Resource(Tree.randomId(), apiVersion, kind);
    }

    public static Metadata asMetadata(Yaml.Mapping m) {
        String namespace = null;
        String name = "";
        Annotations annotations = null;
        Labels labels = null;
        for (Yaml.Mapping.Entry e : m.getEntries()) {
            String key = e.getKey().getValue();
            Object value = e.getValue() instanceof Yaml.Scalar ? ((Yaml.Scalar)e.getValue()).getValue() : e.getValue();
            switch (key) {
                case "namespace": {
                    namespace = (String)value;
                    break;
                }
                case "name": {
                    name = (String)value;
                    break;
                }
                case "labels": {
                    labels = K8S.asLabels((Yaml.Mapping)value);
                    break;
                }
                case "annotations": {
                    annotations = K8S.asAnnotations((Yaml.Mapping)value);
                }
            }
        }
        return new Metadata(Tree.randomId(), namespace, name, annotations, labels);
    }

    public static Annotations asAnnotations(@Nullable Yaml.Mapping m) {
        if (m == null) {
            return new Annotations(Tree.randomId(), Collections.emptySet());
        }
        HashSet<String> keys = new HashSet<String>();
        for (Yaml.Mapping.Entry e : m.getEntries()) {
            keys.add(e.getKey().getValue());
        }
        return new Annotations(Tree.randomId(), keys);
    }

    public static Labels asLabels(@Nullable Yaml.Mapping m) {
        if (m == null) {
            return new Labels(Tree.randomId(), Collections.emptySet());
        }
        HashSet<String> keys = new HashSet<String>();
        for (Yaml.Mapping.Entry e : m.getEntries()) {
            keys.add(e.getKey().getValue());
        }
        return new Labels(Tree.randomId(), keys);
    }

    public static ResourceLimits asResourceLimits(@Nullable Yaml.Scalar s) {
        if (null == s) {
            return new ResourceLimits(Tree.randomId(), null);
        }
        return new ResourceLimits(Tree.randomId(), new ResourceLimit(s.getValue()));
    }

    @Nullable
    public static Service asService(@Nullable Yaml.Mapping m) {
        if (m == null) {
            return null;
        }
        return new Service(Tree.randomId(), m.getEntries().stream().filter(e -> "type".equals(e.getKey().getValue())).findFirst().map(e -> ((Yaml.Scalar)e.getValue()).getValue()).orElse("ClusterIP"));
    }

    public static boolean inMappingEntry(String jsonPath, @Nullable Cursor cursor) {
        return K8S.inMappingEntry(new JsonPathMatcher(jsonPath), cursor);
    }

    public static boolean inMappingEntry(JsonPathMatcher jsonPath, @Nullable Cursor cursor) {
        return K8S.firstEnclosingEntryMatching(jsonPath, cursor).isPresent();
    }

    public static Optional<Cursor> firstEnclosingEntryMatching(String jsonPath, @Nullable Cursor cursor) {
        return K8S.firstEnclosingEntryMatching(new JsonPathMatcher(jsonPath), cursor);
    }

    public static Optional<Cursor> firstEnclosingEntryMatching(JsonPathMatcher jsonPath, @Nullable Cursor cursor) {
        Yaml.Mapping.Entry e;
        if (cursor == null) {
            return Optional.empty();
        }
        Yaml.Mapping.Entry entry = e = cursor.getValue() instanceof Yaml.Mapping.Entry ? (Yaml.Mapping.Entry)cursor.getValue() : (Yaml.Mapping.Entry)cursor.firstEnclosing(Yaml.Mapping.Entry.class);
        if (e == null || e.getKey() == cursor.getValue()) {
            return Optional.empty();
        }
        return jsonPath.find(cursor).flatMap(found -> {
            if (found instanceof List) {
                return ((List)found).stream().map(o -> {
                    Cursor c;
                    for (c = cursor; c != null && c.getValue() != o; c = c.getParent()) {
                    }
                    return c;
                }).filter(Objects::nonNull).findFirst();
            }
            if (found == cursor.getValue() || found instanceof Yaml.Mapping.Entry && ((Yaml.Mapping.Entry)found).getValue() == cursor.getValue()) {
                return Optional.of(cursor);
            }
            return Optional.empty();
        });
    }

    public static class RBAC
    implements K8S {
        private final UUID id;

        public static boolean inRules(Cursor cursor) {
            return K8S.inMappingEntry("$.rules", cursor);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RBAC)) {
                return false;
            }
            RBAC other = (RBAC)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RBAC;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public RBAC(UUID id) {
            this.id = id;
        }

        public UUID getId() {
            return this.id;
        }

        public String toString() {
            return "K8S.RBAC(id=" + this.getId() + ")";
        }
    }

    public static class Ingress
    implements K8S {
        private final UUID id;

        public static boolean isTlsConfigured(Cursor cursor) {
            Optional tls = new JsonPathMatcher("$.spec.tls[*].hosts").find(cursor);
            return tls.isPresent();
        }

        public static boolean isDisallowHttpConfigured(Cursor cursor) {
            Optional tls = new JsonPathMatcher("$.metadata.annotations['kubernetes.io/ingress.allow-http']").find(cursor);
            return tls.map(o -> {
                Yaml.Mapping.Entry e;
                if (o instanceof Yaml.Mapping.Entry && (e = (Yaml.Mapping.Entry)o).getValue() instanceof Yaml.Scalar) {
                    return "false".equals(((Yaml.Scalar)e.getValue()).getValue());
                }
                return false;
            }).orElse(false);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Ingress)) {
                return false;
            }
            Ingress other = (Ingress)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Ingress;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Ingress(UUID id) {
            this.id = id;
        }

        public UUID getId() {
            return this.id;
        }

        public String toString() {
            return "K8S.Ingress(id=" + this.getId() + ")";
        }
    }

    public static class Service
    implements K8S {
        private final UUID id;
        @Nullable
        private final String type;

        public static boolean isServiceSpec(Cursor cursor) {
            return K8S.firstEnclosingEntryMatching("$.spec", cursor).filter(c -> c == cursor).isPresent();
        }

        public static boolean inServiceSpec(Cursor cursor) {
            return K8S.inMappingEntry("$.spec", cursor);
        }

        public static boolean inExternalIPs(Cursor cursor) {
            return cursor.getPathAsStream(o -> o instanceof Yaml.Mapping.Entry && ((Yaml.Mapping.Entry)o).getKey().getValue().equals("externalIPs")).findFirst().isPresent();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Service)) {
                return false;
            }
            Service other = (Service)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Service;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Service(UUID id, String type) {
            this.id = id;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        public String getType() {
            return this.type;
        }

        public String toString() {
            return "K8S.Service(id=" + this.getId() + ", type=" + this.getType() + ")";
        }
    }

    public static class ResourceLimits
    implements K8S {
        private final UUID id;
        private final ResourceLimit value;

        public static boolean inResources(Cursor cursor) {
            return K8S.inMappingEntry("..spec.containers[*].resources", cursor);
        }

        public static boolean inLimits(String type, Cursor cursor) {
            return K8S.inMappingEntry("..spec.containers[*].resources.limits." + type, cursor);
        }

        public static boolean inRequests(String type, Cursor cursor) {
            return K8S.inMappingEntry("..spec.containers[*].resources.requests." + type, cursor);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResourceLimits)) {
                return false;
            }
            ResourceLimits other = (ResourceLimits)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ResourceLimits;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public ResourceLimits(UUID id, ResourceLimit value) {
            this.id = id;
            this.value = value;
        }

        public UUID getId() {
            return this.id;
        }

        public ResourceLimit getValue() {
            return this.value;
        }

        public String toString() {
            return "K8S.ResourceLimits(id=" + this.getId() + ", value=" + this.getValue() + ")";
        }
    }

    public static class InitContainers
    implements K8S {
        private final UUID id;

        public static boolean inInitContainerSpec(Cursor cursor) {
            return K8S.inMappingEntry("..spec.initContainers[*].*", cursor);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InitContainers)) {
                return false;
            }
            InitContainers other = (InitContainers)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InitContainers;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public InitContainers(UUID id) {
            this.id = id;
        }

        public UUID getId() {
            return this.id;
        }

        public String toString() {
            return "K8S.InitContainers(id=" + this.getId() + ")";
        }
    }

    public static class Containers
    implements K8S {
        private final UUID id;

        public static boolean inContainerSpec(Cursor cursor) {
            return K8S.inMappingEntry("..spec.containers[*].*", cursor);
        }

        public static boolean isImageName(Cursor cursor) {
            return cursor.getPathAsStream(o -> o instanceof Yaml.Mapping.Entry && ((Yaml.Mapping.Entry)o).getKey().getValue().equals("image")).findFirst().isPresent();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Containers)) {
                return false;
            }
            Containers other = (Containers)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Containers;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Containers(UUID id) {
            this.id = id;
        }

        public UUID getId() {
            return this.id;
        }

        public String toString() {
            return "K8S.Containers(id=" + this.getId() + ")";
        }
    }

    public static class Pod
    implements K8S {
        private final UUID id;

        public static boolean inSpec(Cursor cursor) {
            return K8S.inMappingEntry("..spec.*", cursor);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Pod)) {
                return false;
            }
            Pod other = (Pod)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Pod;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Pod(UUID id) {
            this.id = id;
        }

        public UUID getId() {
            return this.id;
        }

        public String toString() {
            return "K8S.Pod(id=" + this.getId() + ")";
        }
    }

    public static class Labels
    implements K8S {
        private final UUID id;
        private final Set<String> keys;

        public static boolean inLabels(Cursor cursor) {
            return K8S.inMappingEntry("..metadata.labels.*", cursor);
        }

        public boolean valueMatches(String name, Pattern regex, Cursor cursor) {
            Yaml.Mapping.Entry e;
            Yaml.Mapping.Entry entry = e = cursor.getValue() instanceof Yaml.Mapping.Entry ? (Yaml.Mapping.Entry)cursor.getValue() : (Yaml.Mapping.Entry)cursor.firstEnclosing(Yaml.Mapping.Entry.class);
            if (e == null) {
                return false;
            }
            if (!name.equals(e.getKey().getValue())) {
                return false;
            }
            if (!(e.getValue() instanceof Yaml.Scalar)) {
                return false;
            }
            String value = ((Yaml.Scalar)e.getValue()).getValue();
            return regex.matcher(value).matches();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Labels)) {
                return false;
            }
            Labels other = (Labels)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Labels;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Labels(UUID id, Set<String> keys) {
            this.id = id;
            this.keys = keys;
        }

        public UUID getId() {
            return this.id;
        }

        public Set<String> getKeys() {
            return this.keys;
        }

        public String toString() {
            return "K8S.Labels(id=" + this.getId() + ", keys=" + this.getKeys() + ")";
        }
    }

    public static class Annotations
    implements K8S {
        private final UUID id;
        private final Set<String> keys;

        public static boolean inAnnotations(Cursor cursor) {
            return K8S.inMappingEntry("..metadata.annotations.*", cursor);
        }

        public boolean valueMatches(String name, Pattern regex, Cursor cursor) {
            Yaml.Mapping.Entry e;
            Yaml.Mapping.Entry entry = e = cursor.getValue() instanceof Yaml.Mapping.Entry ? (Yaml.Mapping.Entry)cursor.getValue() : (Yaml.Mapping.Entry)cursor.firstEnclosing(Yaml.Mapping.Entry.class);
            if (e == null) {
                return false;
            }
            if (!name.equals(e.getKey().getValue())) {
                return false;
            }
            if (!(e.getValue() instanceof Yaml.Scalar)) {
                return false;
            }
            String value = ((Yaml.Scalar)e.getValue()).getValue();
            return regex.matcher(value).matches();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Annotations)) {
                return false;
            }
            Annotations other = (Annotations)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Annotations;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Annotations(UUID id, Set<String> keys) {
            this.id = id;
            this.keys = keys;
        }

        public UUID getId() {
            return this.id;
        }

        public Set<String> getKeys() {
            return this.keys;
        }

        public String toString() {
            return "K8S.Annotations(id=" + this.getId() + ", keys=" + this.getKeys() + ")";
        }
    }

    public static class Metadata
    implements K8S {
        private final UUID id;
        @Nullable
        private final String namespace;
        private final String name;
        @Nullable
        private final Annotations annotations;
        @Nullable
        private final Labels labels;

        public static boolean isMetadata(Cursor cursor) {
            return K8S.firstEnclosingEntryMatching("$.metadata", cursor).filter(c -> c.getValue() == cursor.getValue()).isPresent();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Metadata)) {
                return false;
            }
            Metadata other = (Metadata)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Metadata;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Metadata(UUID id, String namespace, String name, Annotations annotations, Labels labels) {
            this.id = id;
            this.namespace = namespace;
            this.name = name;
            this.annotations = annotations;
            this.labels = labels;
        }

        public UUID getId() {
            return this.id;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getName() {
            return this.name;
        }

        public Annotations getAnnotations() {
            return this.annotations;
        }

        public Labels getLabels() {
            return this.labels;
        }

        public String toString() {
            return "K8S.Metadata(id=" + this.getId() + ", namespace=" + this.getNamespace() + ", name=" + this.getName() + ", annotations=" + this.getAnnotations() + ", labels=" + this.getLabels() + ")";
        }
    }

    public static class Resource
    implements K8S {
        private final UUID id;
        private final String apiVersion;
        private final String kind;

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Resource)) {
                return false;
            }
            Resource other = (Resource)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Resource;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Resource(UUID id, String apiVersion, String kind) {
            this.id = id;
            this.apiVersion = apiVersion;
            this.kind = kind;
        }

        public UUID getId() {
            return this.id;
        }

        public String getApiVersion() {
            return this.apiVersion;
        }

        public String getKind() {
            return this.kind;
        }

        public String toString() {
            return "K8S.Resource(id=" + this.getId() + ", apiVersion=" + this.getApiVersion() + ", kind=" + this.getKind() + ")";
        }
    }
}

