/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kubernetes.search;

import java.util.regex.Pattern;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.HasSourcePath;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.kubernetes.search.EntryMarkingVisitor;
import org.openrewrite.kubernetes.tree.K8S;
import org.openrewrite.yaml.tree.Yaml;

public final class FindAnnotation
extends Recipe {
    @Option(displayName="Annotation name", description="The name of the annotation to search for the existence of.", example="mycompany.io/annotation")
    private final String annotationName;
    @Option(displayName="Value", description="An optional regex expression that will find values that match.", example="value.*", required=false)
    @Nullable
    private final String value;
    @Option(displayName="Optional file matcher", description="Matching files will be modified. This is a glob expression.", required=false, example="**/pod-*.yml")
    @Nullable
    private final String fileMatcher;

    public String getDisplayName() {
        return "Find annotation";
    }

    public String getDescription() {
        return "Find annotations that optionally match a given regex.";
    }

    @Nullable
    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        if (this.fileMatcher != null) {
            return new HasSourcePath(this.fileMatcher);
        }
        return null;
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        final Pattern pattern = this.value != null ? Pattern.compile(this.value) : null;
        final String found = "found:" + this.annotationName;
        final String valid = "found:" + this.value;
        return new EntryMarkingVisitor(){

            public Yaml.Scalar visitScalar(Yaml.Scalar scalar, ExecutionContext executionContext) {
                Cursor c = this.getCursor();
                if (K8S.Annotations.inAnnotations(c)) {
                    K8S.Annotations annos = K8S.asAnnotations((Yaml.Mapping)c.firstEnclosing(Yaml.Mapping.class));
                    if (FindAnnotation.this.value == null && annos.getKeys().contains(FindAnnotation.this.annotationName)) {
                        c.putMessageOnFirstEnclosing(Yaml.Mapping.Entry.class, MARKER_KEY, (Object)found);
                    } else if (pattern != null && annos.valueMatches(FindAnnotation.this.annotationName, pattern, c)) {
                        c.putMessageOnFirstEnclosing(Yaml.Mapping.Entry.class, MARKER_KEY, (Object)valid);
                    }
                }
                return super.visitScalar(scalar, (Object)executionContext);
            }
        };
    }

    public FindAnnotation(String annotationName, String value, String fileMatcher) {
        this.annotationName = annotationName;
        this.value = value;
        this.fileMatcher = fileMatcher;
    }

    public String getAnnotationName() {
        return this.annotationName;
    }

    public String getValue() {
        return this.value;
    }

    public String getFileMatcher() {
        return this.fileMatcher;
    }

    public String toString() {
        return "FindAnnotation(annotationName=" + this.getAnnotationName() + ", value=" + this.getValue() + ", fileMatcher=" + this.getFileMatcher() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindAnnotation)) {
            return false;
        }
        FindAnnotation other = (FindAnnotation)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$annotationName = this.getAnnotationName();
        String other$annotationName = other.getAnnotationName();
        if (this$annotationName == null ? other$annotationName != null : !this$annotationName.equals(other$annotationName)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$fileMatcher = this.getFileMatcher();
        String other$fileMatcher = other.getFileMatcher();
        return !(this$fileMatcher == null ? other$fileMatcher != null : !this$fileMatcher.equals(other$fileMatcher));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FindAnnotation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $annotationName = this.getAnnotationName();
        result = result * 59 + ($annotationName == null ? 43 : $annotationName.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $fileMatcher = this.getFileMatcher();
        result = result * 59 + ($fileMatcher == null ? 43 : $fileMatcher.hashCode());
        return result;
    }
}

