/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kubernetes.search;

import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.HasSourcePath;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.kubernetes.ContainerImage;
import org.openrewrite.kubernetes.tree.K8S;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class FindImage
extends Recipe {
    @Option(displayName="Repository", description="The repository part of the image name to search for in containers and initContainers.", example="gcr.io", required=false)
    @Nullable
    private final String repository;
    @Option(displayName="Image name", description="The image name to search for in containers and initContainers.", example="nginx")
    private final String imageName;
    @Option(displayName="Image tag", description="The tag part of the image name to search for in containers and initContainers.", example="v1.2.3", required=false)
    @Nullable
    private final String imageTag;
    @Option(displayName="Include initContainers", description="Boolean to indicate whether or not to treat initContainers/image identically to containers/image.", example="false", required=false)
    private final boolean includeInitContainers;
    @Option(displayName="Optional file matcher", description="Matching files will be modified. This is a glob expression.", required=false, example="**/pod-*.yml")
    @Nullable
    private final String fileMatcher;

    public String getDisplayName() {
        return "Find image by name";
    }

    public String getDescription() {
        return "The image name to search for in containers and initContainers.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        if (this.fileMatcher != null) {
            return new HasSourcePath(this.fileMatcher);
        }
        return null;
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        final ContainerImage.ImageName imageToSearch = new ContainerImage.ImageName(this.repository, this.imageName, this.imageTag, "*");
        final String result = imageToSearch.toString();
        return new YamlIsoVisitor<ExecutionContext>(){

            public Yaml.Scalar visitScalar(Yaml.Scalar scalar, ExecutionContext ctx) {
                ContainerImage image;
                Cursor c = this.getCursor();
                if ((K8S.Containers.inContainerSpec(c) || FindImage.this.includeInitContainers && K8S.InitContainers.inInitContainerSpec(c)) && K8S.Containers.isImageName(c) && (image = new ContainerImage(scalar.getValue())).getImageName().matches(imageToSearch)) {
                    return scalar.withMarkers(scalar.getMarkers().searchResult(result));
                }
                return super.visitScalar(scalar, (Object)ctx);
            }
        };
    }

    public FindImage(String repository, String imageName, String imageTag, boolean includeInitContainers, String fileMatcher) {
        this.repository = repository;
        this.imageName = imageName;
        this.imageTag = imageTag;
        this.includeInitContainers = includeInitContainers;
        this.fileMatcher = fileMatcher;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getImageName() {
        return this.imageName;
    }

    public String getImageTag() {
        return this.imageTag;
    }

    public boolean isIncludeInitContainers() {
        return this.includeInitContainers;
    }

    public String getFileMatcher() {
        return this.fileMatcher;
    }

    public String toString() {
        return "FindImage(repository=" + this.getRepository() + ", imageName=" + this.getImageName() + ", imageTag=" + this.getImageTag() + ", includeInitContainers=" + this.isIncludeInitContainers() + ", fileMatcher=" + this.getFileMatcher() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindImage)) {
            return false;
        }
        FindImage other = (FindImage)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isIncludeInitContainers() != other.isIncludeInitContainers()) {
            return false;
        }
        String this$repository = this.getRepository();
        String other$repository = other.getRepository();
        if (this$repository == null ? other$repository != null : !this$repository.equals(other$repository)) {
            return false;
        }
        String this$imageName = this.getImageName();
        String other$imageName = other.getImageName();
        if (this$imageName == null ? other$imageName != null : !this$imageName.equals(other$imageName)) {
            return false;
        }
        String this$imageTag = this.getImageTag();
        String other$imageTag = other.getImageTag();
        if (this$imageTag == null ? other$imageTag != null : !this$imageTag.equals(other$imageTag)) {
            return false;
        }
        String this$fileMatcher = this.getFileMatcher();
        String other$fileMatcher = other.getFileMatcher();
        return !(this$fileMatcher == null ? other$fileMatcher != null : !this$fileMatcher.equals(other$fileMatcher));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FindImage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isIncludeInitContainers() ? 79 : 97);
        String $repository = this.getRepository();
        result = result * 59 + ($repository == null ? 43 : $repository.hashCode());
        String $imageName = this.getImageName();
        result = result * 59 + ($imageName == null ? 43 : $imageName.hashCode());
        String $imageTag = this.getImageTag();
        result = result * 59 + ($imageTag == null ? 43 : $imageTag.hashCode());
        String $fileMatcher = this.getFileMatcher();
        result = result * 59 + ($fileMatcher == null ? 43 : $fileMatcher.hashCode());
        return result;
    }
}

