/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kubernetes.services;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.HasSourcePath;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.kubernetes.search.EntryMarkingVisitor;
import org.openrewrite.kubernetes.tree.K8S;
import org.openrewrite.yaml.tree.Yaml;

public final class FindServiceExternalIPs
extends Recipe {
    private static final String FIND_IPS = "findips";
    @Option(displayName="IP addresses", description="The list of IP addresses of which at least one external IP should .", example="192.168.0.1")
    private final Set<String> externalIPs;
    @Option(displayName="Find missing", description="Whether to treat this search as finding Services whose externalIPs do not contain any of the query IPs.", required=false)
    private final boolean findMissing;
    @Option(displayName="Optional file matcher", description="Matching files will be modified. This is a glob expression.", required=false, example="**/pod-*.yml")
    @Nullable
    private final String fileMatcher;

    public String getDisplayName() {
        return "Find uses of `externalIP`";
    }

    public String getDescription() {
        return "Find any `Service` whose `externalIP` list contains, or does not contain, one of a list of IPs.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        if (this.fileMatcher != null) {
            return new HasSourcePath(this.fileMatcher);
        }
        return null;
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        final String result = (this.findMissing ? "missing" : "found") + " ip";
        return new EntryMarkingVisitor(){

            public Yaml.Sequence visitSequence(Yaml.Sequence sequence, ExecutionContext ctx) {
                Cursor c = this.getCursor();
                if (K8S.Service.inExternalIPs(c)) {
                    boolean matches;
                    List ips = sequence.getEntries().stream().map(e -> ((Yaml.Scalar)e.getBlock()).getValue()).collect(Collectors.toList());
                    boolean bl = FindServiceExternalIPs.this.findMissing ? ips.stream().noneMatch(FindServiceExternalIPs.this.externalIPs::contains) : (matches = ips.stream().anyMatch(FindServiceExternalIPs.this.externalIPs::contains));
                    if (matches) {
                        c.putMessageOnFirstEnclosing(Yaml.Mapping.Entry.class, MARKER_KEY, (Object)result);
                    }
                }
                return super.visitSequence(sequence, (Object)ctx);
            }
        };
    }

    public FindServiceExternalIPs(Set<String> externalIPs, boolean findMissing, String fileMatcher) {
        this.externalIPs = externalIPs;
        this.findMissing = findMissing;
        this.fileMatcher = fileMatcher;
    }

    public Set<String> getExternalIPs() {
        return this.externalIPs;
    }

    public boolean isFindMissing() {
        return this.findMissing;
    }

    public String getFileMatcher() {
        return this.fileMatcher;
    }

    public String toString() {
        return "FindServiceExternalIPs(externalIPs=" + this.getExternalIPs() + ", findMissing=" + this.isFindMissing() + ", fileMatcher=" + this.getFileMatcher() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindServiceExternalIPs)) {
            return false;
        }
        FindServiceExternalIPs other = (FindServiceExternalIPs)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isFindMissing() != other.isFindMissing()) {
            return false;
        }
        Set<String> this$externalIPs = this.getExternalIPs();
        Set<String> other$externalIPs = other.getExternalIPs();
        if (this$externalIPs == null ? other$externalIPs != null : !((Object)this$externalIPs).equals(other$externalIPs)) {
            return false;
        }
        String this$fileMatcher = this.getFileMatcher();
        String other$fileMatcher = other.getFileMatcher();
        return !(this$fileMatcher == null ? other$fileMatcher != null : !this$fileMatcher.equals(other$fileMatcher));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FindServiceExternalIPs;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isFindMissing() ? 79 : 97);
        Set<String> $externalIPs = this.getExternalIPs();
        result = result * 59 + ($externalIPs == null ? 43 : ((Object)$externalIPs).hashCode());
        String $fileMatcher = this.getFileMatcher();
        result = result * 59 + ($fileMatcher == null ? 43 : $fileMatcher.hashCode());
        return result;
    }
}

