/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kubernetes;

import java.beans.ConstructorProperties;
import org.intellij.lang.annotations.Language;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.kubernetes.KubernetesVisitor;
import org.openrewrite.kubernetes.tree.KubernetesModel;
import org.openrewrite.yaml.MergeYaml;
import org.openrewrite.yaml.tree.Yaml;

public final class AddConfiguration
extends Recipe {
    @Option(displayName="API version", description="The Kubernetes resource API version to use.", example="policy/v1beta1", required=false)
    @Nullable
    private final String apiVersion;
    @Option(displayName="Resource kind", description="The Kubernetes resource type the configured is required on.", example="PodSecurityPolicy")
    private final String resourceKind;
    @Option(displayName="Configuration path", description="A JsonPath expression to locate Kubernetes configuration. Must be an absolute path.", example="$.spec")
    private final String configurationPath;
    @Option(displayName="Value", description="The configuration that is added when necessary, including the key.", example="privileged: false")
    @Language(value="yml")
    private final String value;

    public Validated validate() {
        return super.validate().and(Validated.test((String)"configurationPath", (String)"Configuration path must be absolute (i.e. must start with $).", (Object)this.configurationPath, p -> p.startsWith("$")));
    }

    public String getDisplayName() {
        return "Add Kubernetes configuration";
    }

    public String getDescription() {
        return "Add default required configuration when it is missing.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new KubernetesVisitor<ExecutionContext>(){

            public Yaml visitDocument(Yaml.Document document, ExecutionContext ctx) {
                KubernetesModel model = this.getKubernetesModel();
                if (!AddConfiguration.this.resourceKind.equals(model.getKind())) {
                    return document;
                }
                if (AddConfiguration.this.apiVersion != null && !AddConfiguration.this.apiVersion.equals(model.getApiVersion())) {
                    return document;
                }
                this.doAfterVisit(new MergeYaml(AddConfiguration.this.configurationPath, AddConfiguration.this.value, Boolean.valueOf(true), null).getVisitor());
                return document;
            }
        };
    }

    @ConstructorProperties(value={"apiVersion", "resourceKind", "configurationPath", "value"})
    public AddConfiguration(@Nullable String apiVersion, String resourceKind, String configurationPath, String value) {
        this.apiVersion = apiVersion;
        this.resourceKind = resourceKind;
        this.configurationPath = configurationPath;
        this.value = value;
    }

    @Nullable
    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getResourceKind() {
        return this.resourceKind;
    }

    public String getConfigurationPath() {
        return this.configurationPath;
    }

    public String getValue() {
        return this.value;
    }

    @NonNull
    public String toString() {
        return "AddConfiguration(apiVersion=" + this.getApiVersion() + ", resourceKind=" + this.getResourceKind() + ", configurationPath=" + this.getConfigurationPath() + ", value=" + this.getValue() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddConfiguration)) {
            return false;
        }
        AddConfiguration other = (AddConfiguration)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$apiVersion = this.getApiVersion();
        String other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) {
            return false;
        }
        String this$resourceKind = this.getResourceKind();
        String other$resourceKind = other.getResourceKind();
        if (this$resourceKind == null ? other$resourceKind != null : !this$resourceKind.equals(other$resourceKind)) {
            return false;
        }
        String this$configurationPath = this.getConfigurationPath();
        String other$configurationPath = other.getConfigurationPath();
        if (this$configurationPath == null ? other$configurationPath != null : !this$configurationPath.equals(other$configurationPath)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        String $resourceKind = this.getResourceKind();
        result = result * 59 + ($resourceKind == null ? 43 : $resourceKind.hashCode());
        String $configurationPath = this.getConfigurationPath();
        result = result * 59 + ($configurationPath == null ? 43 : $configurationPath.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}

