/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kubernetes;

import java.beans.ConstructorProperties;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Objects;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.yaml.tree.Yaml;

public final class ContainerImage {
    private static final FileSystem FS = FileSystems.getDefault();
    private final ImageName imageName;

    public ContainerImage(Yaml.Scalar scalar) {
        this(scalar.getValue());
    }

    public ContainerImage(String imageName) {
        String repository = null;
        String image = imageName;
        String tag = null;
        String digest = null;
        int idx = imageName.lastIndexOf(64);
        if (idx > -1) {
            digest = imageName.substring(idx + 1);
            imageName = imageName.substring(0, idx);
        }
        if ((idx = imageName.lastIndexOf(58)) > -1) {
            image = imageName.substring(0, idx);
            tag = imageName.substring(idx + 1);
            imageName = imageName.substring(0, idx);
        }
        if ((idx = imageName.lastIndexOf(47)) > -1) {
            image = imageName.substring(idx + 1);
            String s = imageName.substring(0, idx);
            if (!StringUtils.isNullOrEmpty((String)s)) {
                repository = s;
            }
        }
        this.imageName = new ImageName(repository, image, tag, digest);
    }

    public ImageName getImageName() {
        return this.imageName;
    }

    @NonNull
    public String toString() {
        return "ContainerImage(imageName=" + this.getImageName() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContainerImage)) {
            return false;
        }
        ContainerImage other = (ContainerImage)o;
        ImageName this$imageName = this.getImageName();
        ImageName other$imageName = other.getImageName();
        return !(this$imageName == null ? other$imageName != null : !((Object)this$imageName).equals(other$imageName));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ImageName $imageName = this.getImageName();
        result = result * 59 + ($imageName == null ? 43 : ((Object)$imageName).hashCode());
        return result;
    }

    public static final class ImageName {
        @Nullable
        private final String repository;
        @Nullable
        private final String image;
        @Nullable
        private final String tag;
        @Nullable
        private final String digest;

        public boolean matches(ImageName otherName) {
            boolean matchesRepo = ImageName.bothNull(this.getRepository(), otherName.getRepository()) || Objects.equals(this.getRepository(), otherName.getRepository()) || ImageName.isGlobMatch(this.getRepository(), otherName.getRepository());
            boolean matchesImage = ImageName.bothNull(this.getImage(), otherName.getImage()) || Objects.equals(this.getImage(), otherName.getImage()) || ImageName.isGlobMatch(this.getImage(), otherName.getImage());
            boolean matchesTag = ImageName.bothNull(this.getTag(), otherName.getTag()) || Objects.equals(this.getTag(), otherName.getTag()) || ImageName.isGlobMatch(this.getTag(), otherName.getTag());
            boolean matchesDigest = ImageName.bothNull(this.getDigest(), otherName.getDigest()) || Objects.equals(this.getDigest(), otherName.getDigest()) || ImageName.isGlobMatch(this.getDigest(), otherName.getDigest());
            return matchesRepo && matchesImage && matchesTag && matchesDigest;
        }

        public boolean hasDigest() {
            return !StringUtils.isNullOrEmpty((String)this.digest);
        }

        public String toString() {
            String s = "";
            if (!StringUtils.isNullOrEmpty((String)this.repository)) {
                s = s + this.repository + "/";
            }
            s = s + this.image;
            if (!StringUtils.isNullOrEmpty((String)this.tag)) {
                s = s + ":" + this.tag;
            }
            if (!StringUtils.isNullOrEmpty((String)this.digest) && !"*".equals(this.digest)) {
                s = s + "@" + this.digest;
            }
            return s;
        }

        private static boolean bothNull(@Nullable String s1, @Nullable String s2) {
            return s1 == null && s2 == null;
        }

        private static boolean isGlobMatch(@Nullable String s1, @Nullable String s2) {
            String[] parts;
            if ("*".equals(s2)) {
                return true;
            }
            PathMatcher pm = FS.getPathMatcher("glob:" + s2);
            Path path = s1 != null && s1.contains("/") ? ((parts = s1.split("/")).length > 1 ? Paths.get(parts[0], Arrays.copyOfRange(parts, 1, parts.length - 1)) : Paths.get(parts[0], new String[0])) : (s1 == null ? Paths.get("", new String[0]) : Paths.get(s1, new String[0]));
            return pm.matches(path);
        }

        @ConstructorProperties(value={"repository", "image", "tag", "digest"})
        public ImageName(@Nullable String repository, @Nullable String image, @Nullable String tag, @Nullable String digest) {
            this.repository = repository;
            this.image = image;
            this.tag = tag;
            this.digest = digest;
        }

        @Nullable
        public String getRepository() {
            return this.repository;
        }

        @Nullable
        public String getImage() {
            return this.image;
        }

        @Nullable
        public String getTag() {
            return this.tag;
        }

        @Nullable
        public String getDigest() {
            return this.digest;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ImageName)) {
                return false;
            }
            ImageName other = (ImageName)o;
            String this$repository = this.getRepository();
            String other$repository = other.getRepository();
            if (this$repository == null ? other$repository != null : !this$repository.equals(other$repository)) {
                return false;
            }
            String this$image = this.getImage();
            String other$image = other.getImage();
            if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
                return false;
            }
            String this$tag = this.getTag();
            String other$tag = other.getTag();
            if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) {
                return false;
            }
            String this$digest = this.getDigest();
            String other$digest = other.getDigest();
            return !(this$digest == null ? other$digest != null : !this$digest.equals(other$digest));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $repository = this.getRepository();
            result = result * 59 + ($repository == null ? 43 : $repository.hashCode());
            String $image = this.getImage();
            result = result * 59 + ($image == null ? 43 : $image.hashCode());
            String $tag = this.getTag();
            result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
            String $digest = this.getDigest();
            result = result * 59 + ($digest == null ? 43 : $digest.hashCode());
            return result;
        }

        @NonNull
        public ImageName withRepository(@Nullable String repository) {
            return this.repository == repository ? this : new ImageName(repository, this.image, this.tag, this.digest);
        }

        @NonNull
        public ImageName withImage(@Nullable String image) {
            return this.image == image ? this : new ImageName(this.repository, image, this.tag, this.digest);
        }

        @NonNull
        public ImageName withTag(@Nullable String tag) {
            return this.tag == tag ? this : new ImageName(this.repository, this.image, tag, this.digest);
        }
    }
}

