/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kubernetes.services;

import java.beans.ConstructorProperties;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.kubernetes.tree.K8S;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class UpdateServiceExternalIP
extends Recipe {
    @Option(displayName="IP to find", description="An `externalIP` address to find in the service's external IPs.", example="192.168.0.1")
    private final String ipToFind;
    @Option(displayName="IP to update", description="An `externalIP` address to update to in the service's external IPs.", example="10.10.0.1")
    private final String ipToUpdate;
    @Option(displayName="Optional file matcher", description="Matching files will be modified. This is a glob expression.", required=false, example="**/pod-*.yml")
    @Nullable
    private final String fileMatcher;

    public String getDisplayName() {
        return "Update `Service` `externalIP`";
    }

    public String getDescription() {
        return "Swap out an IP address with another one in `Service` `externalIP` settings.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        YamlIsoVisitor<ExecutionContext> visitor = new YamlIsoVisitor<ExecutionContext>(){

            public Yaml.Sequence.Entry visitSequenceEntry(Yaml.Sequence.Entry entry, ExecutionContext ctx) {
                Cursor c = this.getCursor();
                if (K8S.Service.inExternalIPs(c)) {
                    Yaml.Scalar s = (Yaml.Scalar)entry.getBlock();
                    if (UpdateServiceExternalIP.this.ipToFind.equals(s.getValue())) {
                        return entry.withBlock((Yaml.Block)s.withValue(UpdateServiceExternalIP.this.ipToUpdate));
                    }
                }
                return super.visitSequenceEntry(entry, (Object)ctx);
            }
        };
        return this.fileMatcher != null ? Preconditions.check((Recipe)new FindSourceFiles(this.fileMatcher), (TreeVisitor)visitor) : visitor;
    }

    @ConstructorProperties(value={"ipToFind", "ipToUpdate", "fileMatcher"})
    public UpdateServiceExternalIP(String ipToFind, String ipToUpdate, @Nullable String fileMatcher) {
        this.ipToFind = ipToFind;
        this.ipToUpdate = ipToUpdate;
        this.fileMatcher = fileMatcher;
    }

    public String getIpToFind() {
        return this.ipToFind;
    }

    public String getIpToUpdate() {
        return this.ipToUpdate;
    }

    @Nullable
    public String getFileMatcher() {
        return this.fileMatcher;
    }

    @NonNull
    public String toString() {
        return "UpdateServiceExternalIP(ipToFind=" + this.getIpToFind() + ", ipToUpdate=" + this.getIpToUpdate() + ", fileMatcher=" + this.getFileMatcher() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateServiceExternalIP)) {
            return false;
        }
        UpdateServiceExternalIP other = (UpdateServiceExternalIP)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$ipToFind = this.getIpToFind();
        String other$ipToFind = other.getIpToFind();
        if (this$ipToFind == null ? other$ipToFind != null : !this$ipToFind.equals(other$ipToFind)) {
            return false;
        }
        String this$ipToUpdate = this.getIpToUpdate();
        String other$ipToUpdate = other.getIpToUpdate();
        if (this$ipToUpdate == null ? other$ipToUpdate != null : !this$ipToUpdate.equals(other$ipToUpdate)) {
            return false;
        }
        String this$fileMatcher = this.getFileMatcher();
        String other$fileMatcher = other.getFileMatcher();
        return !(this$fileMatcher == null ? other$fileMatcher != null : !this$fileMatcher.equals(other$fileMatcher));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpdateServiceExternalIP;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $ipToFind = this.getIpToFind();
        result = result * 59 + ($ipToFind == null ? 43 : $ipToFind.hashCode());
        String $ipToUpdate = this.getIpToUpdate();
        result = result * 59 + ($ipToUpdate == null ? 43 : $ipToUpdate.hashCode());
        String $fileMatcher = this.getFileMatcher();
        result = result * 59 + ($fileMatcher == null ? 43 : $fileMatcher.hashCode());
        return result;
    }
}

