/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kubernetes.search;

import org.openrewrite.ExecutionContext;
import org.openrewrite.HasSourcePath;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.kubernetes.tree.K8S;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public class FindNonTlsIngress
extends Recipe {
    private static final SearchResult MISSING_TLS = new SearchResult(Tree.randomId(), "missing TLS");
    private static final SearchResult MISSING_DISALLOW_HTTP = new SearchResult(Tree.randomId(), "missing disallow http");
    @Option(displayName="Optional file matcher", description="Matching files will be modified. This is a glob expression.", required=false, example="**/pod-*.yml")
    @Nullable
    String fileMatcher;

    public String getDisplayName() {
        return "Find non-TLS Ingresses";
    }

    public String getDescription() {
        return "Find Ingress resources that don't disallow HTTP or don't have TLS configured.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        YamlIsoVisitor<ExecutionContext> visitor = new YamlIsoVisitor<ExecutionContext>(){

            public Yaml.Document visitDocument(Yaml.Document document, ExecutionContext ctx) {
                if (K8S.inKind("Ingress", this.getCursor())) {
                    Yaml.Document d = super.visitDocument(document, (Object)ctx);
                    if (!K8S.Ingress.isTlsConfigured(this.getCursor())) {
                        d = d.withMarkers(d.getMarkers().addIfAbsent((Marker)MISSING_TLS));
                    }
                    if (!K8S.Ingress.isDisallowHttpConfigured(this.getCursor())) {
                        d = d.withMarkers(d.getMarkers().addIfAbsent((Marker)MISSING_DISALLOW_HTTP));
                    }
                    return d;
                }
                return super.visitDocument(document, (Object)ctx);
            }
        };
        return this.fileMatcher != null ? Preconditions.check((TreeVisitor)new HasSourcePath(this.fileMatcher), (TreeVisitor)visitor) : visitor;
    }
}

