/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kubernetes;

import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.kubernetes.UpdateKubernetesModel;
import org.openrewrite.kubernetes.tree.KubernetesModel;
import org.openrewrite.yaml.YamlVisitor;
import org.openrewrite.yaml.tree.Yaml;

public class KubernetesVisitor<P>
extends YamlVisitor<P> {
    public boolean isAcceptable(SourceFile sourceFile, P p) {
        if (!(sourceFile instanceof Yaml.Documents)) {
            return false;
        }
        Yaml.Documents docs = (Yaml.Documents)sourceFile;
        for (Yaml.Document doc : docs.getDocuments()) {
            if (doc.getMarkers().findFirst(KubernetesModel.class).orElse(null) != null) continue;
            return false;
        }
        return true;
    }

    protected KubernetesModel getKubernetesModel() {
        Yaml.Document doc = (Yaml.Document)this.getCursor().firstEnclosing(Yaml.Document.class);
        if (doc == null) {
            throw new IllegalStateException("The KubernetesModel marker is placed on Yaml.Document elements, but no Yaml.Document could be found in " + this.getCursor());
        }
        return (KubernetesModel)doc.getMarkers().findFirst(KubernetesModel.class).orElseThrow(() -> new IllegalStateException("KubernetesVisitor should not be visiting a YAML document without a KubernetesModel"));
    }

    public void maybeUpdateModel() {
        for (TreeVisitor afterVisit : this.getAfterVisit()) {
            if (!(afterVisit instanceof UpdateKubernetesModel)) continue;
            return;
        }
        this.doAfterVisit((TreeVisitor)new UpdateKubernetesModel());
    }
}

