/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kubernetes.search;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.HasSourcePath;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.kubernetes.ContainerImage;
import org.openrewrite.kubernetes.tree.K8S;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class FindDisallowedImageTags
extends Recipe {
    @Option(displayName="Disallowed tags", description="The set of image tags to find which are considered disallowed. This is a comma-separated list of tags.", example="latest")
    private final String disallowedTags;
    @Option(displayName="Include initContainers", description="Boolean to indicate whether or not to treat initContainers/image identically to containers/image.", example="false", required=false)
    private final boolean includeInitContainers;
    @Option(displayName="Optional file matcher", description="Matching files will be modified. This is a glob expression.", required=false, example="**/pod-*.yml")
    @Nullable
    private final String fileMatcher;

    public String getDisplayName() {
        return "Find disallowed image tags";
    }

    public String getDescription() {
        return "The set of image tags to find which are considered disallowed.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final List<String> disallowed = Arrays.asList(this.disallowedTags.split("\\s*,\\s*"));
        YamlIsoVisitor<ExecutionContext> visitor = new YamlIsoVisitor<ExecutionContext>(){

            public Yaml.Scalar visitScalar(Yaml.Scalar scalar, ExecutionContext ctx) {
                Yaml.Scalar s = super.visitScalar(scalar, (Object)ctx);
                Cursor c = this.getCursor();
                if ((K8S.Containers.inContainerSpec(c) || FindDisallowedImageTags.this.includeInitContainers && K8S.InitContainers.inInitContainerSpec(c)) && K8S.Containers.isImageName(c)) {
                    ContainerImage image = new ContainerImage(scalar);
                    List foundDisallowed = disallowed.stream().filter(t -> t.equals(image.getImageName().getTag())).collect(Collectors.toList());
                    if (!foundDisallowed.isEmpty()) {
                        s = (Yaml.Scalar)SearchResult.found((Tree)s, (String)("disallowed tag: [" + String.join((CharSequence)", ", foundDisallowed) + "]"));
                    }
                }
                return s;
            }
        };
        return this.fileMatcher != null ? Preconditions.check((TreeVisitor)new HasSourcePath(this.fileMatcher), (TreeVisitor)visitor) : visitor;
    }

    @ConstructorProperties(value={"disallowedTags", "includeInitContainers", "fileMatcher"})
    public FindDisallowedImageTags(String disallowedTags, boolean includeInitContainers, @Nullable String fileMatcher) {
        this.disallowedTags = disallowedTags;
        this.includeInitContainers = includeInitContainers;
        this.fileMatcher = fileMatcher;
    }

    public String getDisallowedTags() {
        return this.disallowedTags;
    }

    public boolean isIncludeInitContainers() {
        return this.includeInitContainers;
    }

    @Nullable
    public String getFileMatcher() {
        return this.fileMatcher;
    }

    @NonNull
    public String toString() {
        return "FindDisallowedImageTags(disallowedTags=" + this.getDisallowedTags() + ", includeInitContainers=" + this.isIncludeInitContainers() + ", fileMatcher=" + this.getFileMatcher() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindDisallowedImageTags)) {
            return false;
        }
        FindDisallowedImageTags other = (FindDisallowedImageTags)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isIncludeInitContainers() != other.isIncludeInitContainers()) {
            return false;
        }
        String this$disallowedTags = this.getDisallowedTags();
        String other$disallowedTags = other.getDisallowedTags();
        if (this$disallowedTags == null ? other$disallowedTags != null : !this$disallowedTags.equals(other$disallowedTags)) {
            return false;
        }
        String this$fileMatcher = this.getFileMatcher();
        String other$fileMatcher = other.getFileMatcher();
        return !(this$fileMatcher == null ? other$fileMatcher != null : !this$fileMatcher.equals(other$fileMatcher));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindDisallowedImageTags;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isIncludeInitContainers() ? 79 : 97);
        String $disallowedTags = this.getDisallowedTags();
        result = result * 59 + ($disallowedTags == null ? 43 : $disallowedTags.hashCode());
        String $fileMatcher = this.getFileMatcher();
        result = result * 59 + ($fileMatcher == null ? 43 : $fileMatcher.hashCode());
        return result;
    }
}

