/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kubernetes.search;

import java.beans.ConstructorProperties;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.HasSourcePath;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.kubernetes.ContainerImage;
import org.openrewrite.kubernetes.tree.K8S;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class FindMissingDigest
extends Recipe {
    @Option(displayName="Include initContainers", description="Boolean to indicate whether or not to treat initContainers/image identically to containers/image.", example="false", required=false)
    private final boolean includeInitContainers;
    @Option(displayName="Optional file matcher", description="Matching files will be modified. This is a glob expression.", required=false, example="**/pod-*.yml")
    @Nullable
    private final String fileMatcher;

    public String getDisplayName() {
        return "Find missing image digest";
    }

    public String getDescription() {
        return "Find instances of a container name that fails to specify a digest.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final String result = "missing digest";
        YamlIsoVisitor<ExecutionContext> visitor = new YamlIsoVisitor<ExecutionContext>(){

            public Yaml.Scalar visitScalar(Yaml.Scalar scalar, ExecutionContext ctx) {
                ContainerImage image;
                Cursor c = this.getCursor();
                if ((K8S.Containers.inContainerSpec(c) || FindMissingDigest.this.includeInitContainers && K8S.InitContainers.inInitContainerSpec(c)) && K8S.Containers.isImageName(c) && !(image = new ContainerImage(scalar.getValue())).getImageName().hasDigest()) {
                    return (Yaml.Scalar)SearchResult.found((Tree)scalar, (String)result);
                }
                return super.visitScalar(scalar, (Object)ctx);
            }
        };
        return this.fileMatcher != null ? Preconditions.check((TreeVisitor)new HasSourcePath(this.fileMatcher), (TreeVisitor)visitor) : visitor;
    }

    @ConstructorProperties(value={"includeInitContainers", "fileMatcher"})
    public FindMissingDigest(boolean includeInitContainers, @Nullable String fileMatcher) {
        this.includeInitContainers = includeInitContainers;
        this.fileMatcher = fileMatcher;
    }

    public boolean isIncludeInitContainers() {
        return this.includeInitContainers;
    }

    @Nullable
    public String getFileMatcher() {
        return this.fileMatcher;
    }

    @NonNull
    public String toString() {
        return "FindMissingDigest(includeInitContainers=" + this.isIncludeInitContainers() + ", fileMatcher=" + this.getFileMatcher() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindMissingDigest)) {
            return false;
        }
        FindMissingDigest other = (FindMissingDigest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isIncludeInitContainers() != other.isIncludeInitContainers()) {
            return false;
        }
        String this$fileMatcher = this.getFileMatcher();
        String other$fileMatcher = other.getFileMatcher();
        return !(this$fileMatcher == null ? other$fileMatcher != null : !this$fileMatcher.equals(other$fileMatcher));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindMissingDigest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isIncludeInitContainers() ? 79 : 97);
        String $fileMatcher = this.getFileMatcher();
        result = result * 59 + ($fileMatcher == null ? 43 : $fileMatcher.hashCode());
        return result;
    }
}

