/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kubernetes.resource;

import java.beans.ConstructorProperties;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.kubernetes.resource.ResourceLimit;
import org.openrewrite.kubernetes.tree.K8S;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class FindExceedsResourceRatio
extends Recipe {
    @Option(displayName="Resource limit type", description="The type of resource limit to search for.", example="memory", valid={"cpu", "memory"})
    private final String resourceType;
    @Option(displayName="Resource ratio", description="The maximum ratio allowed between requests and limits.", example="2")
    private final String ratioLimit;
    @Option(displayName="Optional file matcher", description="Matching files will be modified. This is a glob expression.", required=false, example="**/pod-*.yml")
    @Nullable
    private final String fileMatcher;

    public String getDisplayName() {
        return "Find exceeds resource ratio";
    }

    public String getDescription() {
        return "Find resource manifests that have requests to limits ratios beyond a specific maximum.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final String result = "exceeds max " + this.resourceType + " limits/requests ratio of " + this.ratioLimit;
        final int resourceLimit = Integer.parseInt(this.ratioLimit);
        YamlIsoVisitor<ExecutionContext> visitor = new YamlIsoVisitor<ExecutionContext>(){

            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                Yaml.Mapping.Entry e = super.visitMappingEntry(entry, (Object)ctx);
                Cursor c = this.getCursor();
                if (K8S.ResourceLimits.inResources(c)) {
                    JsonPathMatcher requestsMatcher = new JsonPathMatcher(".requests." + FindExceedsResourceRatio.this.resourceType);
                    JsonPathMatcher limitsMatcher = new JsonPathMatcher(".limits." + FindExceedsResourceRatio.this.resourceType);
                    return requestsMatcher.find(c).flatMap(req -> limitsMatcher.find(c).map(lim -> {
                        String reqValStr = FindExceedsResourceRatio.valueFromEntry(req);
                        if (reqValStr == null) {
                            return e;
                        }
                        ResourceLimit reqLimit = new ResourceLimit(reqValStr);
                        String limValStr = FindExceedsResourceRatio.valueFromEntry(lim);
                        if (limValStr == null) {
                            return e;
                        }
                        ResourceLimit limLimit = new ResourceLimit(limValStr);
                        if (reqLimit.exceedsRatio(resourceLimit, limLimit.getValue())) {
                            return (Yaml.Mapping.Entry)SearchResult.found((Tree)e, (String)result);
                        }
                        return e;
                    })).orElse(e);
                }
                return e;
            }
        };
        return this.fileMatcher != null ? Preconditions.check((Recipe)new FindSourceFiles(this.fileMatcher), (TreeVisitor)visitor) : visitor;
    }

    @Nullable
    private static String valueFromEntry(Object o) {
        if (!(o instanceof Yaml.Mapping.Entry)) {
            return null;
        }
        Yaml.Mapping.Entry e = (Yaml.Mapping.Entry)o;
        if (!(e.getValue() instanceof Yaml.Scalar)) {
            return null;
        }
        Yaml.Scalar s = (Yaml.Scalar)e.getValue();
        return s.getValue();
    }

    @ConstructorProperties(value={"resourceType", "ratioLimit", "fileMatcher"})
    public FindExceedsResourceRatio(String resourceType, String ratioLimit, @Nullable String fileMatcher) {
        this.resourceType = resourceType;
        this.ratioLimit = ratioLimit;
        this.fileMatcher = fileMatcher;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getRatioLimit() {
        return this.ratioLimit;
    }

    @Nullable
    public String getFileMatcher() {
        return this.fileMatcher;
    }

    @NonNull
    public String toString() {
        return "FindExceedsResourceRatio(resourceType=" + this.getResourceType() + ", ratioLimit=" + this.getRatioLimit() + ", fileMatcher=" + this.getFileMatcher() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindExceedsResourceRatio)) {
            return false;
        }
        FindExceedsResourceRatio other = (FindExceedsResourceRatio)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$resourceType = this.getResourceType();
        String other$resourceType = other.getResourceType();
        if (this$resourceType == null ? other$resourceType != null : !this$resourceType.equals(other$resourceType)) {
            return false;
        }
        String this$ratioLimit = this.getRatioLimit();
        String other$ratioLimit = other.getRatioLimit();
        if (this$ratioLimit == null ? other$ratioLimit != null : !this$ratioLimit.equals(other$ratioLimit)) {
            return false;
        }
        String this$fileMatcher = this.getFileMatcher();
        String other$fileMatcher = other.getFileMatcher();
        return !(this$fileMatcher == null ? other$fileMatcher != null : !this$fileMatcher.equals(other$fileMatcher));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindExceedsResourceRatio;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $resourceType = this.getResourceType();
        result = result * 59 + ($resourceType == null ? 43 : $resourceType.hashCode());
        String $ratioLimit = this.getRatioLimit();
        result = result * 59 + ($ratioLimit == null ? 43 : $ratioLimit.hashCode());
        String $fileMatcher = this.getFileMatcher();
        result = result * 59 + ($fileMatcher == null ? 43 : $fileMatcher.hashCode());
        return result;
    }
}

