/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kubernetes.services;

import java.beans.ConstructorProperties;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.kubernetes.search.EntryMarkingVisitor;
import org.openrewrite.kubernetes.tree.K8S;
import org.openrewrite.yaml.tree.Yaml;

public final class FindServicesByType
extends Recipe {
    @Option(displayName="Service type", description="Type of Kubernetes Service to find.", example="NodePort", valid={"ClusterIP", "NodePort", "LoadBalancer", "ExternalName"})
    private final String serviceType;
    @Option(displayName="Optional file matcher", description="Matching files will be modified. This is a glob expression.", required=false, example="**/pod-*.yml")
    @Nullable
    private final String fileMatcher;

    public String getDisplayName() {
        return "Service type";
    }

    public String getDescription() {
        return "Type of Kubernetes `Service` to find.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final String result = "type:" + this.serviceType;
        EntryMarkingVisitor visitor = new EntryMarkingVisitor(){

            public Yaml.Mapping visitMapping(Yaml.Mapping mapping, ExecutionContext ctx) {
                Cursor c = this.getCursor();
                if (K8S.Service.isServiceSpec(c)) {
                    K8S.Service svc = K8S.asService(mapping);
                    if (FindServicesByType.this.serviceType.equals(svc.getType())) {
                        c.getParentOrThrow().putMessageOnFirstEnclosing(Yaml.Mapping.Entry.class, MARKER_KEY, (Object)result);
                        return mapping;
                    }
                }
                return super.visitMapping(mapping, (Object)ctx);
            }
        };
        return this.fileMatcher != null ? Preconditions.check((Recipe)new FindSourceFiles(this.fileMatcher), (TreeVisitor)visitor) : visitor;
    }

    @ConstructorProperties(value={"serviceType", "fileMatcher"})
    public FindServicesByType(String serviceType, @Nullable String fileMatcher) {
        this.serviceType = serviceType;
        this.fileMatcher = fileMatcher;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    @Nullable
    public String getFileMatcher() {
        return this.fileMatcher;
    }

    @NonNull
    public String toString() {
        return "FindServicesByType(serviceType=" + this.getServiceType() + ", fileMatcher=" + this.getFileMatcher() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindServicesByType)) {
            return false;
        }
        FindServicesByType other = (FindServicesByType)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$serviceType = this.getServiceType();
        String other$serviceType = other.getServiceType();
        if (this$serviceType == null ? other$serviceType != null : !this$serviceType.equals(other$serviceType)) {
            return false;
        }
        String this$fileMatcher = this.getFileMatcher();
        String other$fileMatcher = other.getFileMatcher();
        return !(this$fileMatcher == null ? other$fileMatcher != null : !this$fileMatcher.equals(other$fileMatcher));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindServicesByType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serviceType = this.getServiceType();
        result = result * 59 + ($serviceType == null ? 43 : $serviceType.hashCode());
        String $fileMatcher = this.getFileMatcher();
        result = result * 59 + ($fileMatcher == null ? 43 : $fileMatcher.hashCode());
        return result;
    }
}

