/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kubernetes.rbac;

import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.kubernetes.KubernetesVisitor;
import org.openrewrite.kubernetes.tree.K8S;
import org.openrewrite.yaml.YamlParser;
import org.openrewrite.yaml.search.FindKey;
import org.openrewrite.yaml.tree.Yaml;

public final class AddRuleToRole
extends Recipe {
    @Option(displayName="RBAC Resource type", description="Type of RBAC resource to which this recipe adds a rule.", example="ClusterRole", valid={"ClusterRole", "Role"})
    private final String rbacResourceType;
    @Option(displayName="RBAC Resource name", description="Glob pattern of the name of the RBAC resource to which this recipe adds a rule.", example="my-cluster-role")
    private final String rbacResourceName;
    @Option(displayName="API groups", description="Comma-separated list of API groups to which this rule refers.", example=",v1")
    private final Set<String> apiGroups;
    @Option(displayName="Resource types", description="Comma-separated list of Kubernetes resource types to which this rule refers.", example="pods")
    private final Set<String> resources;
    @Option(displayName="Resource names", description="Comma-separated list of names of Kubernetes resources to which this rule applies.", example="my-pod", required=false)
    @Nullable
    private final Set<String> resourceNames;
    @Option(displayName="API verbs", description="The API verbs to enable with this rule.", example="get,list")
    private final Set<String> verbs;
    @Option(displayName="Optional file matcher", description="Matching files will be modified. This is a glob expression.", required=false, example="**/pod-*.yml")
    @Nullable
    private final String fileMatcher;

    public AddRuleToRole(String rbacResourceType, String rbacResourceName, Set<String> apiGroups, Set<String> resources, @Nullable Set<String> resourceNames, Set<String> verbs, @Nullable String fileMatcher) {
        this.rbacResourceType = rbacResourceType;
        this.rbacResourceName = rbacResourceName;
        this.apiGroups = apiGroups;
        this.resources = resources;
        this.resourceNames = resourceNames;
        this.verbs = verbs;
        this.fileMatcher = fileMatcher;
    }

    public String getDisplayName() {
        return "Add RBAC rules";
    }

    public String getDescription() {
        return "Add RBAC rules to ClusterRoles or namespaced Roles.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        KubernetesVisitor<ExecutionContext> visitor = new KubernetesVisitor<ExecutionContext>(){
            private final PathMatcher globMatcher;
            private final Yaml.Sequence.Entry newSequenceEntry;
            {
                this.globMatcher = FileSystems.getDefault().getPathMatcher("glob:" + AddRuleToRole.this.rbacResourceName);
                this.newSequenceEntry = AddRuleToRole.this.generateSequence();
            }

            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                Cursor c = this.getCursor();
                if (K8S.inKind(AddRuleToRole.this.rbacResourceType, c) && K8S.Metadata.isMetadata(c)) {
                    K8S.Metadata meta = K8S.asMetadata((Yaml.Mapping)entry.getValue());
                    Yaml.Document document = (Yaml.Document)c.dropParentUntil(Yaml.Document.class::isInstance).getValue();
                    if (this.globMatcher.matches(Paths.get(meta.getName(), new String[0])) && this.isSupportedAPI(document)) {
                        if (this.containsRule(FindKey.find((Yaml)document, (String)"$.rules[*].*"))) {
                            return entry;
                        }
                        Yaml.Block addToRules = ((Yaml.Mapping.Entry)FindKey.find((Yaml)document, (String)"$.rules").toArray()[0]).getValue();
                        this.getCursor().putMessageOnFirstEnclosing(Yaml.Document.class, "RULE_KEY", (Object)addToRules);
                    }
                }
                return (Yaml.Mapping.Entry)super.visitMappingEntry(entry, (Object)ctx);
            }

            public Yaml.Sequence visitSequence(Yaml.Sequence sequence, ExecutionContext ctx) {
                Object found = this.getCursor().getNearestMessage("RULE_KEY");
                if (found == sequence) {
                    sequence = sequence.withEntries(ListUtils.concat((List)sequence.getEntries(), (Object)this.newSequenceEntry));
                    this.maybeUpdateModel();
                }
                return (Yaml.Sequence)super.visitSequence(sequence, (Object)ctx);
            }

            private boolean isSupportedAPI(Yaml.Document document) {
                Set apiVersion = FindKey.find((Yaml)document, (String)"$.apiVersion");
                return apiVersion.size() == 1 && apiVersion.toArray()[0] instanceof Yaml.Mapping.Entry && ((Yaml.Mapping.Entry)apiVersion.toArray()[0]).getValue() instanceof Yaml.Scalar && "rbac.authorization.k8s.io/v1".equals(((Yaml.Scalar)((Yaml.Mapping.Entry)apiVersion.toArray()[0]).getValue()).getValue());
            }

            private boolean containsRule(Set<Yaml> rules) {
                for (Yaml yaml : rules) {
                    Yaml.Mapping.Entry entry = (Yaml.Mapping.Entry)yaml;
                    Set<String> values = this.extractEntryValues(entry);
                    if ("apiGroups".equals(entry.getKey().getValue()) && (values.size() != AddRuleToRole.this.apiGroups.size() || !values.containsAll(AddRuleToRole.this.apiGroups))) {
                        return false;
                    }
                    if ("resources".equals(entry.getKey().getValue()) && (values.size() != AddRuleToRole.this.resources.size() || !values.containsAll(AddRuleToRole.this.resources))) {
                        return false;
                    }
                    if ("verbs".equals(entry.getKey().getValue()) && (values.size() != AddRuleToRole.this.verbs.size() || !values.containsAll(AddRuleToRole.this.verbs))) {
                        return false;
                    }
                    if (AddRuleToRole.this.resourceNames == null || !"resourceNames".equals(entry.getKey().getValue()) || values.size() == AddRuleToRole.this.resourceNames.size() && values.containsAll(AddRuleToRole.this.resourceNames)) continue;
                    return false;
                }
                return true;
            }

            private Set<String> extractEntryValues(@Nullable Yaml.Mapping.Entry entry) {
                HashSet<String> values = new HashSet<String>();
                if (entry != null) {
                    if (entry.getValue() instanceof Yaml.Scalar) {
                        values.add(((Yaml.Scalar)entry.getValue()).getValue());
                    } else if (entry.getValue() instanceof Yaml.Sequence) {
                        for (Yaml.Sequence.Entry yaml : ((Yaml.Sequence)entry.getValue()).getEntries()) {
                            if (!(yaml.getBlock() instanceof Yaml.Scalar)) continue;
                            values.add(((Yaml.Scalar)yaml.getBlock()).getValue());
                        }
                    }
                }
                return values;
            }
        };
        return this.fileMatcher != null ? Preconditions.check((Recipe)new FindSourceFiles(this.fileMatcher), (TreeVisitor)visitor) : visitor;
    }

    @Nullable
    private String setToString(@Nullable Set<String> strs) {
        if (strs == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean needsComma = false;
        for (String s : strs) {
            if (needsComma) {
                sb.append(", ");
            } else {
                needsComma = true;
            }
            sb.append("\"").append(s).append("\"");
        }
        sb.append("]");
        return sb.toString();
    }

    private Yaml.Sequence.Entry generateSequence() {
        String apiGroupsStr = this.setToString(this.apiGroups);
        String resourcesStr = this.setToString(this.resources);
        String resourceNamesStr = this.setToString(this.resourceNames);
        String verbsStr = this.setToString(this.verbs);
        Stream<Yaml.Documents> docs = new YamlParser().parse(new String[]{"- apiGroups: " + apiGroupsStr + "\n  resources: " + resourcesStr + "\n" + (resourceNamesStr != null ? "  resourceNames: " + resourceNamesStr + "\n" : "") + "  verbs: " + verbsStr}).map(Yaml.Documents.class::cast);
        return ((Yaml.Sequence.Entry)((Yaml.Sequence)((Yaml.Document)docs.findFirst().get().getDocuments().get(0)).getBlock()).getEntries().get(0)).withPrefix("\n");
    }

    @Generated
    public String getRbacResourceType() {
        return this.rbacResourceType;
    }

    @Generated
    public String getRbacResourceName() {
        return this.rbacResourceName;
    }

    @Generated
    public Set<String> getApiGroups() {
        return this.apiGroups;
    }

    @Generated
    public Set<String> getResources() {
        return this.resources;
    }

    @Nullable
    @Generated
    public Set<String> getResourceNames() {
        return this.resourceNames;
    }

    @Generated
    public Set<String> getVerbs() {
        return this.verbs;
    }

    @Nullable
    @Generated
    public String getFileMatcher() {
        return this.fileMatcher;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddRuleToRole(rbacResourceType=" + this.getRbacResourceType() + ", rbacResourceName=" + this.getRbacResourceName() + ", apiGroups=" + this.getApiGroups() + ", resources=" + this.getResources() + ", resourceNames=" + this.getResourceNames() + ", verbs=" + this.getVerbs() + ", fileMatcher=" + this.getFileMatcher() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddRuleToRole)) {
            return false;
        }
        AddRuleToRole other = (AddRuleToRole)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$rbacResourceType = this.getRbacResourceType();
        String other$rbacResourceType = other.getRbacResourceType();
        if (this$rbacResourceType == null ? other$rbacResourceType != null : !this$rbacResourceType.equals(other$rbacResourceType)) {
            return false;
        }
        String this$rbacResourceName = this.getRbacResourceName();
        String other$rbacResourceName = other.getRbacResourceName();
        if (this$rbacResourceName == null ? other$rbacResourceName != null : !this$rbacResourceName.equals(other$rbacResourceName)) {
            return false;
        }
        Set<String> this$apiGroups = this.getApiGroups();
        Set<String> other$apiGroups = other.getApiGroups();
        if (this$apiGroups == null ? other$apiGroups != null : !((Object)this$apiGroups).equals(other$apiGroups)) {
            return false;
        }
        Set<String> this$resources = this.getResources();
        Set<String> other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
            return false;
        }
        Set<String> this$resourceNames = this.getResourceNames();
        Set<String> other$resourceNames = other.getResourceNames();
        if (this$resourceNames == null ? other$resourceNames != null : !((Object)this$resourceNames).equals(other$resourceNames)) {
            return false;
        }
        Set<String> this$verbs = this.getVerbs();
        Set<String> other$verbs = other.getVerbs();
        if (this$verbs == null ? other$verbs != null : !((Object)this$verbs).equals(other$verbs)) {
            return false;
        }
        String this$fileMatcher = this.getFileMatcher();
        String other$fileMatcher = other.getFileMatcher();
        return !(this$fileMatcher == null ? other$fileMatcher != null : !this$fileMatcher.equals(other$fileMatcher));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddRuleToRole;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $rbacResourceType = this.getRbacResourceType();
        result = result * 59 + ($rbacResourceType == null ? 43 : $rbacResourceType.hashCode());
        String $rbacResourceName = this.getRbacResourceName();
        result = result * 59 + ($rbacResourceName == null ? 43 : $rbacResourceName.hashCode());
        Set<String> $apiGroups = this.getApiGroups();
        result = result * 59 + ($apiGroups == null ? 43 : ((Object)$apiGroups).hashCode());
        Set<String> $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
        Set<String> $resourceNames = this.getResourceNames();
        result = result * 59 + ($resourceNames == null ? 43 : ((Object)$resourceNames).hashCode());
        Set<String> $verbs = this.getVerbs();
        result = result * 59 + ($verbs == null ? 43 : ((Object)$verbs).hashCode());
        String $fileMatcher = this.getFileMatcher();
        result = result * 59 + ($fileMatcher == null ? 43 : $fileMatcher.hashCode());
        return result;
    }
}

