/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kubernetes.search;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.kubernetes.tree.K8S;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class FindResourceMissingConfiguration
extends Recipe {
    @Option(displayName="Resource kind", description="The Kubernetes resource type to search on.", example="Pod", required=false)
    @Nullable
    private final String resourceKind;
    @Option(displayName="Configuration path", description="A JsonPath expression to locate Kubernetes configuration.", example="$.spec.containers.livenessProbe")
    private final String configurationPath;
    @Option(displayName="Optional file matcher", description="Matching files will be modified. This is a glob expression.", required=false, example="**/pod-*.yml")
    @Nullable
    private final String fileMatcher;

    public String getDisplayName() {
        return "Find missing configuration";
    }

    public String getDescription() {
        return "Find Kubernetes resources with missing configuration.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        YamlIsoVisitor<ExecutionContext> visitor = new YamlIsoVisitor<ExecutionContext>(){

            public Yaml.Document visitDocument(Yaml.Document document, ExecutionContext ctx) {
                boolean inKind;
                Yaml.Block b = (Yaml.Block)this.visit((Tree)document.getBlock(), ctx, this.getCursor());
                boolean bl = inKind = FindResourceMissingConfiguration.this.resourceKind == null || K8S.inKind(FindResourceMissingConfiguration.this.resourceKind, this.getCursor());
                if (inKind && !"true".equals(this.getCursor().getMessage(FindResourceMissingConfiguration.class.getSimpleName()))) {
                    return (Yaml.Document)SearchResult.found((Tree)document.withBlock(b));
                }
                return document;
            }

            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                if (K8S.firstEnclosingEntryMatching(FindResourceMissingConfiguration.this.configurationPath, this.getCursor()).isPresent()) {
                    this.getCursor().putMessageOnFirstEnclosing(Yaml.Document.class, FindResourceMissingConfiguration.class.getSimpleName(), (Object)"true");
                }
                return super.visitMappingEntry(entry, (Object)ctx);
            }
        };
        return this.fileMatcher != null ? Preconditions.check((Recipe)new FindSourceFiles(this.fileMatcher), (TreeVisitor)visitor) : visitor;
    }

    @ConstructorProperties(value={"resourceKind", "configurationPath", "fileMatcher"})
    @Generated
    public FindResourceMissingConfiguration(@Nullable String resourceKind, String configurationPath, @Nullable String fileMatcher) {
        this.resourceKind = resourceKind;
        this.configurationPath = configurationPath;
        this.fileMatcher = fileMatcher;
    }

    @Nullable
    @Generated
    public String getResourceKind() {
        return this.resourceKind;
    }

    @Generated
    public String getConfigurationPath() {
        return this.configurationPath;
    }

    @Nullable
    @Generated
    public String getFileMatcher() {
        return this.fileMatcher;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindResourceMissingConfiguration(resourceKind=" + this.getResourceKind() + ", configurationPath=" + this.getConfigurationPath() + ", fileMatcher=" + this.getFileMatcher() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindResourceMissingConfiguration)) {
            return false;
        }
        FindResourceMissingConfiguration other = (FindResourceMissingConfiguration)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$resourceKind = this.getResourceKind();
        String other$resourceKind = other.getResourceKind();
        if (this$resourceKind == null ? other$resourceKind != null : !this$resourceKind.equals(other$resourceKind)) {
            return false;
        }
        String this$configurationPath = this.getConfigurationPath();
        String other$configurationPath = other.getConfigurationPath();
        if (this$configurationPath == null ? other$configurationPath != null : !this$configurationPath.equals(other$configurationPath)) {
            return false;
        }
        String this$fileMatcher = this.getFileMatcher();
        String other$fileMatcher = other.getFileMatcher();
        return !(this$fileMatcher == null ? other$fileMatcher != null : !this$fileMatcher.equals(other$fileMatcher));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindResourceMissingConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $resourceKind = this.getResourceKind();
        result = result * 59 + ($resourceKind == null ? 43 : $resourceKind.hashCode());
        String $configurationPath = this.getConfigurationPath();
        result = result * 59 + ($configurationPath == null ? 43 : $configurationPath.hashCode());
        String $fileMatcher = this.getFileMatcher();
        result = result * 59 + ($fileMatcher == null ? 43 : $fileMatcher.hashCode());
        return result;
    }
}

