/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kubernetes.tree;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.kubernetes.resource.ResourceLimit;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.tree.Yaml;

@Deprecated
public interface K8S {
    public static boolean inKind(String kind, Cursor cursor) {
        Yaml.Document doc = (Yaml.Document)cursor.firstEnclosing(Yaml.Document.class);
        if (doc == null) {
            return false;
        }
        Resource r = K8S.asResource((Yaml.Mapping)doc.getBlock());
        return kind.equals(r.getKind());
    }

    public static boolean inPod(Cursor cursor) {
        return K8S.inKind("Pod", cursor);
    }

    public static boolean inDaemonSet(Cursor cursor) {
        return K8S.inKind("DaemonSet", cursor);
    }

    public static boolean inStatefulSet(Cursor cursor) {
        return K8S.inKind("StatefulSet", cursor);
    }

    public static boolean inDeployment(Cursor cursor) {
        return K8S.inKind("Deployment", cursor);
    }

    public static boolean inService(Cursor cursor) {
        return K8S.inKind("Service", cursor);
    }

    public static Resource asResource(Yaml.Mapping m) {
        String apiVersion = null;
        String kind = null;
        for (Yaml.Mapping.Entry e : m.getEntries()) {
            Yaml.Block value = e.getValue();
            if ("apiVersion".equals(e.getKey().getValue())) {
                apiVersion = ((Yaml.Scalar)value).getValue();
                continue;
            }
            if (!"kind".equals(e.getKey().getValue())) continue;
            kind = ((Yaml.Scalar)value).getValue();
        }
        return new Resource(Tree.randomId(), apiVersion, kind);
    }

    public static Metadata asMetadata(Yaml.Mapping m) {
        String namespace = null;
        String name = "";
        Annotations annotations = null;
        Labels labels = null;
        for (Yaml.Mapping.Entry e : m.getEntries()) {
            String key = e.getKey().getValue();
            Object value = e.getValue() instanceof Yaml.Scalar ? ((Yaml.Scalar)e.getValue()).getValue() : e.getValue();
            switch (key) {
                case "namespace": {
                    namespace = (String)value;
                    break;
                }
                case "name": {
                    name = (String)value;
                    break;
                }
                case "labels": {
                    labels = K8S.asLabels((Yaml.Mapping)value);
                    break;
                }
                case "annotations": {
                    annotations = K8S.asAnnotations((Yaml.Mapping)value);
                }
            }
        }
        return new Metadata(Tree.randomId(), namespace, name, annotations, labels);
    }

    public static Annotations asAnnotations(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Yaml.Mapping m) {
        if (m == null) {
            return new Annotations(Tree.randomId(), Collections.emptySet());
        }
        HashSet<String> keys = new HashSet<String>();
        for (Yaml.Mapping.Entry e : m.getEntries()) {
            keys.add(e.getKey().getValue());
        }
        return new Annotations(Tree.randomId(), keys);
    }

    public static Labels asLabels(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Yaml.Mapping m) {
        if (m == null) {
            return new Labels(Tree.randomId(), Collections.emptySet());
        }
        HashSet<String> keys = new HashSet<String>();
        for (Yaml.Mapping.Entry e : m.getEntries()) {
            keys.add(e.getKey().getValue());
        }
        return new Labels(Tree.randomId(), keys);
    }

    public static ResourceLimits asResourceLimits(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Yaml.Scalar s) {
        if (null == s) {
            return new ResourceLimits(Tree.randomId(), null);
        }
        return new ResourceLimits(Tree.randomId(), new ResourceLimit(s.getValue()));
    }

    public static @Nullable Service asService(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Yaml.Mapping m) {
        if (m == null) {
            return null;
        }
        return new Service(Tree.randomId(), m.getEntries().stream().filter(e -> "type".equals(e.getKey().getValue())).findFirst().map(e -> ((Yaml.Scalar)e.getValue()).getValue()).orElse("ClusterIP"));
    }

    public static boolean inMappingEntry(String jsonPath, @Nullable Cursor cursor) {
        return K8S.inMappingEntry(new JsonPathMatcher(jsonPath), cursor);
    }

    public static boolean inMappingEntry(JsonPathMatcher jsonPath, @Nullable Cursor cursor) {
        return K8S.firstEnclosingEntryMatching(jsonPath, cursor).isPresent();
    }

    public static Optional<Cursor> firstEnclosingEntryMatching(String jsonPath, @Nullable Cursor cursor) {
        return K8S.firstEnclosingEntryMatching(new JsonPathMatcher(jsonPath), cursor);
    }

    public static Optional<Cursor> firstEnclosingEntryMatching(JsonPathMatcher jsonPath, @Nullable Cursor cursor) {
        Yaml.Mapping.Entry e;
        if (cursor == null) {
            return Optional.empty();
        }
        Yaml.Mapping.Entry entry = e = cursor.getValue() instanceof Yaml.Mapping.Entry ? (Yaml.Mapping.Entry)cursor.getValue() : (Yaml.Mapping.Entry)cursor.firstEnclosing(Yaml.Mapping.Entry.class);
        if (e == null || e.getKey() == cursor.getValue()) {
            return Optional.empty();
        }
        return jsonPath.find(cursor).flatMap(found -> {
            if (found instanceof Yaml.Mapping) {
                return ((Yaml.Mapping)found).getEntries().stream().map(o -> {
                    if (o.getValue() == cursor.getValue()) {
                        return cursor;
                    }
                    return null;
                }).filter(Objects::nonNull).findFirst();
            }
            if (found instanceof List) {
                return ((List)found).stream().map(o -> {
                    Cursor c;
                    for (c = cursor; c != null && c.getValue() != o; c = c.getParent()) {
                    }
                    return c;
                }).filter(Objects::nonNull).findFirst();
            }
            if (found == cursor.getValue() || found instanceof Yaml.Mapping.Entry && ((Yaml.Mapping.Entry)found).getValue() == cursor.getValue()) {
                return Optional.of(cursor);
            }
            return Optional.empty();
        });
    }

    public static class Resource
    implements K8S {
        private final UUID id;
        private final String apiVersion;
        private final String kind;

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Resource)) {
                return false;
            }
            Resource other = (Resource)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            String this$apiVersion = this.getApiVersion();
            String other$apiVersion = other.getApiVersion();
            if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) {
                return false;
            }
            String this$kind = this.getKind();
            String other$kind = other.getKind();
            return !(this$kind == null ? other$kind != null : !this$kind.equals(other$kind));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof Resource;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            String $apiVersion = this.getApiVersion();
            result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
            String $kind = this.getKind();
            result = result * 59 + ($kind == null ? 43 : $kind.hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "apiVersion", "kind"})
        @Generated
        public Resource(UUID id, String apiVersion, String kind) {
            this.id = id;
            this.apiVersion = apiVersion;
            this.kind = kind;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public String getApiVersion() {
            return this.apiVersion;
        }

        @Generated
        public String getKind() {
            return this.kind;
        }

        @NonNull
        @Generated
        public String toString() {
            return "K8S.Resource(id=" + this.getId() + ", apiVersion=" + this.getApiVersion() + ", kind=" + this.getKind() + ")";
        }

        @NonNull
        @Generated
        public Resource withId(UUID id) {
            return this.id == id ? this : new Resource(id, this.apiVersion, this.kind);
        }
    }

    public static class Labels
    implements K8S {
        private final UUID id;
        private final Set<String> keys;

        public static boolean inLabels(Cursor cursor) {
            return K8S.inMappingEntry("..metadata.labels.*", cursor);
        }

        public boolean valueMatches(String name, Pattern regex, Cursor cursor) {
            Yaml.Mapping.Entry e;
            Yaml.Mapping.Entry entry = e = cursor.getValue() instanceof Yaml.Mapping.Entry ? (Yaml.Mapping.Entry)cursor.getValue() : (Yaml.Mapping.Entry)cursor.firstEnclosing(Yaml.Mapping.Entry.class);
            if (e == null) {
                return false;
            }
            if (!name.equals(e.getKey().getValue())) {
                return false;
            }
            if (!(e.getValue() instanceof Yaml.Scalar)) {
                return false;
            }
            String value = ((Yaml.Scalar)e.getValue()).getValue();
            return regex.matcher(value).matches();
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Labels)) {
                return false;
            }
            Labels other = (Labels)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Set<String> this$keys = this.getKeys();
            Set<String> other$keys = other.getKeys();
            return !(this$keys == null ? other$keys != null : !((Object)this$keys).equals(other$keys));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof Labels;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Set<String> $keys = this.getKeys();
            result = result * 59 + ($keys == null ? 43 : ((Object)$keys).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "keys"})
        @Generated
        public Labels(UUID id, Set<String> keys) {
            this.id = id;
            this.keys = keys;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public Set<String> getKeys() {
            return this.keys;
        }

        @NonNull
        @Generated
        public String toString() {
            return "K8S.Labels(id=" + this.getId() + ", keys=" + this.getKeys() + ")";
        }

        @NonNull
        @Generated
        public Labels withId(UUID id) {
            return this.id == id ? this : new Labels(id, this.keys);
        }
    }

    public static class Annotations
    implements K8S {
        private final UUID id;
        private final Set<String> keys;

        public static boolean inAnnotations(Cursor cursor) {
            Cursor parent = cursor.dropParentUntil(is -> is instanceof Yaml.Mapping || is instanceof Yaml.Document);
            if (parent.getValue() instanceof Yaml.Mapping) {
                return new JsonPathMatcher("$.*..metadata.annotations.*").matches(parent);
            }
            return false;
        }

        public boolean valueMatches(String name, Pattern regex, Cursor cursor) {
            Yaml.Mapping.Entry e;
            Yaml.Mapping.Entry entry = e = cursor.getValue() instanceof Yaml.Mapping.Entry ? (Yaml.Mapping.Entry)cursor.getValue() : (Yaml.Mapping.Entry)cursor.firstEnclosing(Yaml.Mapping.Entry.class);
            if (e == null) {
                return false;
            }
            if (!name.equals(e.getKey().getValue())) {
                return false;
            }
            if (!(e.getValue() instanceof Yaml.Scalar)) {
                return false;
            }
            String value = ((Yaml.Scalar)e.getValue()).getValue();
            return regex.matcher(value).matches();
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Annotations)) {
                return false;
            }
            Annotations other = (Annotations)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Set<String> this$keys = this.getKeys();
            Set<String> other$keys = other.getKeys();
            return !(this$keys == null ? other$keys != null : !((Object)this$keys).equals(other$keys));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof Annotations;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Set<String> $keys = this.getKeys();
            result = result * 59 + ($keys == null ? 43 : ((Object)$keys).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "keys"})
        @Generated
        public Annotations(UUID id, Set<String> keys) {
            this.id = id;
            this.keys = keys;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public Set<String> getKeys() {
            return this.keys;
        }

        @NonNull
        @Generated
        public String toString() {
            return "K8S.Annotations(id=" + this.getId() + ", keys=" + this.getKeys() + ")";
        }

        @NonNull
        @Generated
        public Annotations withId(UUID id) {
            return this.id == id ? this : new Annotations(id, this.keys);
        }
    }

    public static class Metadata
    implements K8S {
        private final UUID id;
        private final @Nullable String namespace;
        private final String name;
        private final @Nullable Annotations annotations;
        private final @Nullable Labels labels;

        public static boolean isMetadata(Cursor cursor) {
            return K8S.firstEnclosingEntryMatching("$.metadata", cursor).filter(c -> c.getValue() == cursor.getValue()).isPresent();
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Metadata)) {
                return false;
            }
            Metadata other = (Metadata)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            String this$namespace = this.getNamespace();
            String other$namespace = other.getNamespace();
            if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Annotations this$annotations = this.getAnnotations();
            Annotations other$annotations = other.getAnnotations();
            if (this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations)) {
                return false;
            }
            Labels this$labels = this.getLabels();
            Labels other$labels = other.getLabels();
            return !(this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof Metadata;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            String $namespace = this.getNamespace();
            result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Annotations $annotations = this.getAnnotations();
            result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
            Labels $labels = this.getLabels();
            result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "namespace", "name", "annotations", "labels"})
        @Generated
        public Metadata(UUID id, @Nullable String namespace, String name, @Nullable Annotations annotations, @Nullable Labels labels) {
            this.id = id;
            this.namespace = namespace;
            this.name = name;
            this.annotations = annotations;
            this.labels = labels;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public @Nullable String getNamespace() {
            return this.namespace;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public @Nullable Annotations getAnnotations() {
            return this.annotations;
        }

        @Generated
        public @Nullable Labels getLabels() {
            return this.labels;
        }

        @NonNull
        @Generated
        public String toString() {
            return "K8S.Metadata(id=" + this.getId() + ", namespace=" + this.getNamespace() + ", name=" + this.getName() + ", annotations=" + this.getAnnotations() + ", labels=" + this.getLabels() + ")";
        }

        @NonNull
        @Generated
        public Metadata withId(UUID id) {
            return this.id == id ? this : new Metadata(id, this.namespace, this.name, this.annotations, this.labels);
        }
    }

    public static class ResourceLimits
    implements K8S {
        private final UUID id;
        private final ResourceLimit value;

        public static boolean inResources(Cursor cursor) {
            return K8S.inMappingEntry("$.*..spec.containers[*].resources", cursor);
        }

        public static boolean inLimits(String type, Cursor cursor) {
            return K8S.inMappingEntry("$.*..spec.containers[*].resources.limits." + type, cursor);
        }

        public static boolean inRequests(String type, Cursor cursor) {
            return K8S.inMappingEntry("$.*..spec.containers[*].resources.requests." + type, cursor);
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResourceLimits)) {
                return false;
            }
            ResourceLimits other = (ResourceLimits)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            ResourceLimit this$value = this.getValue();
            ResourceLimit other$value = other.getValue();
            return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof ResourceLimits;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            ResourceLimit $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "value"})
        @Generated
        public ResourceLimits(UUID id, ResourceLimit value) {
            this.id = id;
            this.value = value;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public ResourceLimit getValue() {
            return this.value;
        }

        @NonNull
        @Generated
        public String toString() {
            return "K8S.ResourceLimits(id=" + this.getId() + ", value=" + this.getValue() + ")";
        }

        @NonNull
        @Generated
        public ResourceLimits withId(UUID id) {
            return this.id == id ? this : new ResourceLimits(id, this.value);
        }
    }

    public static class Service
    implements K8S {
        private final UUID id;
        private final @Nullable String type;

        public static boolean isServiceSpec(Cursor cursor) {
            return K8S.firstEnclosingEntryMatching("$.spec", cursor).filter(c -> c == cursor).isPresent();
        }

        public static boolean inServiceSpec(Cursor cursor) {
            return K8S.inMappingEntry("$.spec", cursor);
        }

        public static boolean inExternalIPs(Cursor cursor) {
            return cursor.getPathAsStream(o -> o instanceof Yaml.Mapping.Entry && "externalIPs".equals(((Yaml.Mapping.Entry)o).getKey().getValue())).findFirst().isPresent();
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Service)) {
                return false;
            }
            Service other = (Service)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof Service;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "type"})
        @Generated
        public Service(UUID id, @Nullable String type) {
            this.id = id;
            this.type = type;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public @Nullable String getType() {
            return this.type;
        }

        @NonNull
        @Generated
        public String toString() {
            return "K8S.Service(id=" + this.getId() + ", type=" + this.getType() + ")";
        }

        @NonNull
        @Generated
        public Service withId(UUID id) {
            return this.id == id ? this : new Service(id, this.type);
        }
    }

    public static class RBAC
    implements K8S {
        private final UUID id;

        public static boolean inRules(Cursor cursor) {
            return K8S.inMappingEntry("$.rules", cursor);
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RBAC)) {
                return false;
            }
            RBAC other = (RBAC)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof RBAC;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id"})
        @Generated
        public RBAC(UUID id) {
            this.id = id;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public String toString() {
            return "K8S.RBAC(id=" + this.getId() + ")";
        }

        @NonNull
        @Generated
        public RBAC withId(UUID id) {
            return this.id == id ? this : new RBAC(id);
        }
    }

    public static class Ingress
    implements K8S {
        private final UUID id;

        public static boolean isTlsConfigured(Cursor cursor) {
            Optional tls = new JsonPathMatcher("$.spec.tls[*].hosts").find(cursor);
            return tls.isPresent();
        }

        public static boolean isDisallowHttpConfigured(Cursor cursor) {
            Optional tls = new JsonPathMatcher("$.metadata.annotations['kubernetes.io/ingress.allow-http']").find(cursor);
            return tls.map(o -> {
                Yaml.Mapping.Entry e;
                if (o instanceof Yaml.Mapping.Entry && (e = (Yaml.Mapping.Entry)o).getValue() instanceof Yaml.Scalar) {
                    return "false".equals(((Yaml.Scalar)e.getValue()).getValue());
                }
                return false;
            }).orElse(false);
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Ingress)) {
                return false;
            }
            Ingress other = (Ingress)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof Ingress;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id"})
        @Generated
        public Ingress(UUID id) {
            this.id = id;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public String toString() {
            return "K8S.Ingress(id=" + this.getId() + ")";
        }

        @NonNull
        @Generated
        public Ingress withId(UUID id) {
            return this.id == id ? this : new Ingress(id);
        }
    }

    public static class InitContainers
    implements K8S {
        private final UUID id;

        public static boolean inInitContainerSpec(Cursor cursor) {
            return K8S.inMappingEntry("$.*..spec.initContainers[*].*", cursor);
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InitContainers)) {
                return false;
            }
            InitContainers other = (InitContainers)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof InitContainers;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id"})
        @Generated
        public InitContainers(UUID id) {
            this.id = id;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public String toString() {
            return "K8S.InitContainers(id=" + this.getId() + ")";
        }

        @NonNull
        @Generated
        public InitContainers withId(UUID id) {
            return this.id == id ? this : new InitContainers(id);
        }
    }

    public static class Containers
    implements K8S {
        private final UUID id;

        public static boolean inContainerSpec(Cursor cursor) {
            return K8S.inMappingEntry("$.*..spec.containers[*].*", cursor);
        }

        public static boolean isImageName(Cursor cursor) {
            return cursor.getPathAsStream(o -> o instanceof Yaml.Mapping.Entry && "image".equals(((Yaml.Mapping.Entry)o).getKey().getValue())).findFirst().isPresent();
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Containers)) {
                return false;
            }
            Containers other = (Containers)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof Containers;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id"})
        @Generated
        public Containers(UUID id) {
            this.id = id;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public String toString() {
            return "K8S.Containers(id=" + this.getId() + ")";
        }

        @NonNull
        @Generated
        public Containers withId(UUID id) {
            return this.id == id ? this : new Containers(id);
        }
    }

    public static class Pod
    implements K8S {
        private final UUID id;

        public static boolean inSpec(Cursor cursor) {
            return K8S.inMappingEntry("..spec.*", cursor);
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Pod)) {
                return false;
            }
            Pod other = (Pod)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof Pod;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id"})
        @Generated
        public Pod(UUID id) {
            this.id = id;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public String toString() {
            return "K8S.Pod(id=" + this.getId() + ")";
        }

        @NonNull
        @Generated
        public Pod withId(UUID id) {
            return this.id == id ? this : new Pod(id);
        }
    }
}

