/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kubernetes.services;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.kubernetes.search.EntryMarkingVisitor;
import org.openrewrite.kubernetes.tree.K8S;
import org.openrewrite.yaml.tree.Yaml;

public final class FindServiceExternalIPs
extends Recipe {
    private static final String FIND_IPS = "findips";
    @Option(displayName="IP addresses", description="The list of IP addresses of which at least one external IP should match.", example="192.168.0.1")
    private final Set<String> externalIPs;
    @Option(displayName="Find missing", description="Whether to treat this search as finding Services whose externalIPs do not contain any of the query IPs.", required=false)
    private final @Nullable Boolean findMissing;
    @Option(displayName="Optional file matcher", description="Matching files will be modified. This is a glob expression.", required=false, example="**/pod-*.yml")
    private final @Nullable String fileMatcher;

    public String getDisplayName() {
        return "Find uses of `externalIP`";
    }

    public String getDescription() {
        return "Find any `Service` whose `externalIP` list contains, or does not contain, one of a list of IPs.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final String result = (this.findMissing != false ? "missing" : "found") + " ip";
        EntryMarkingVisitor visitor = new EntryMarkingVisitor(){

            public Yaml.Sequence visitSequence(Yaml.Sequence sequence, ExecutionContext ctx) {
                Cursor c = this.getCursor();
                if (K8S.Service.inExternalIPs(c)) {
                    boolean matches;
                    List ips = sequence.getEntries().stream().map(e -> ((Yaml.Scalar)e.getBlock()).getValue()).collect(Collectors.toList());
                    boolean bl = FindServiceExternalIPs.this.findMissing.booleanValue() ? ips.stream().noneMatch(FindServiceExternalIPs.this.externalIPs::contains) : (matches = ips.stream().anyMatch(FindServiceExternalIPs.this.externalIPs::contains));
                    if (matches) {
                        c.putMessageOnFirstEnclosing(Yaml.Mapping.Entry.class, MARKER_KEY, (Object)result);
                    }
                }
                return super.visitSequence(sequence, (Object)ctx);
            }
        };
        return this.fileMatcher != null ? Preconditions.check((Recipe)new FindSourceFiles(this.fileMatcher), (TreeVisitor)visitor) : visitor;
    }

    @ConstructorProperties(value={"externalIPs", "findMissing", "fileMatcher"})
    @Generated
    public FindServiceExternalIPs(Set<String> externalIPs, @Nullable Boolean findMissing, @Nullable String fileMatcher) {
        this.externalIPs = externalIPs;
        this.findMissing = findMissing;
        this.fileMatcher = fileMatcher;
    }

    @Generated
    public Set<String> getExternalIPs() {
        return this.externalIPs;
    }

    @Generated
    public @Nullable Boolean getFindMissing() {
        return this.findMissing;
    }

    @Generated
    public @Nullable String getFileMatcher() {
        return this.fileMatcher;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindServiceExternalIPs(externalIPs=" + this.getExternalIPs() + ", findMissing=" + this.getFindMissing() + ", fileMatcher=" + this.getFileMatcher() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindServiceExternalIPs)) {
            return false;
        }
        FindServiceExternalIPs other = (FindServiceExternalIPs)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$findMissing = this.getFindMissing();
        Boolean other$findMissing = other.getFindMissing();
        if (this$findMissing == null ? other$findMissing != null : !((Object)this$findMissing).equals(other$findMissing)) {
            return false;
        }
        Set<String> this$externalIPs = this.getExternalIPs();
        Set<String> other$externalIPs = other.getExternalIPs();
        if (this$externalIPs == null ? other$externalIPs != null : !((Object)this$externalIPs).equals(other$externalIPs)) {
            return false;
        }
        String this$fileMatcher = this.getFileMatcher();
        String other$fileMatcher = other.getFileMatcher();
        return !(this$fileMatcher == null ? other$fileMatcher != null : !this$fileMatcher.equals(other$fileMatcher));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof FindServiceExternalIPs;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $findMissing = this.getFindMissing();
        result = result * 59 + ($findMissing == null ? 43 : ((Object)$findMissing).hashCode());
        Set<String> $externalIPs = this.getExternalIPs();
        result = result * 59 + ($externalIPs == null ? 43 : ((Object)$externalIPs).hashCode());
        String $fileMatcher = this.getFileMatcher();
        result = result * 59 + ($fileMatcher == null ? 43 : $fileMatcher.hashCode());
        return result;
    }
}

