/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.launchdarkly;

import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public final class ChangeVariationDefault
extends Recipe {
    @Option(displayName="Feature flag key", description="The key of the feature flag to remove.", example="flag-key-123abc")
    @NonNull
    private final String featureKey;
    @Option(displayName="Default value", description="The default value to use in feature flag invocations.", example="true")
    @NonNull
    private final String defaultValue;
    private static final MethodMatcher BOOL_VARIATION_MATCHER = new MethodMatcher("com.launchdarkly.sdk.server.LDClient boolVariation(String, com.launchdarkly.sdk.*, boolean)", true);
    private static final MethodMatcher STRING_VARIATION_MATCHER = new MethodMatcher("com.launchdarkly.sdk.server.LDClient stringVariation(String, com.launchdarkly.sdk.*, String)", true);
    private static final MethodMatcher INT_VARIATION_MATCHER = new MethodMatcher("com.launchdarkly.sdk.server.LDClient intVariation(String, com.launchdarkly.sdk.*, int)", true);
    private static final MethodMatcher DOUBLE_VARIATION_MATCHER = new MethodMatcher("com.launchdarkly.sdk.server.LDClient doubleVariation(String, com.launchdarkly.sdk.*, double)", true);

    public String getDisplayName() {
        return "Change the default value for feature key";
    }

    public String getDescription() {
        return "Change the default value for `Variation` invocations for feature key.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        JavaIsoVisitor<ExecutionContext> visitor = new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                Expression firstArgument = (Expression)mi.getArguments().get(0);
                Expression lastArgument = (Expression)mi.getArguments().get(mi.getArguments().size() - 1);
                if (BOOL_VARIATION_MATCHER.matches((MethodCall)mi) && J.Literal.isLiteralValue((Expression)firstArgument, (Object)ChangeVariationDefault.this.featureKey)) {
                    return this.changeValue(mi, lastArgument, new J.Literal(Tree.randomId(), Space.SINGLE_SPACE, Markers.EMPTY, (Object)ChangeVariationDefault.this.defaultValue, ChangeVariationDefault.this.defaultValue, null, JavaType.Primitive.Boolean));
                }
                if (STRING_VARIATION_MATCHER.matches((MethodCall)mi) && J.Literal.isLiteralValue((Expression)firstArgument, (Object)ChangeVariationDefault.this.featureKey)) {
                    return this.changeValue(mi, lastArgument, new J.Literal(Tree.randomId(), Space.SINGLE_SPACE, Markers.EMPTY, (Object)ChangeVariationDefault.this.defaultValue, "\"" + ChangeVariationDefault.this.defaultValue + "\"", null, JavaType.Primitive.String));
                }
                if (INT_VARIATION_MATCHER.matches((MethodCall)mi) && J.Literal.isLiteralValue((Expression)firstArgument, (Object)ChangeVariationDefault.this.featureKey)) {
                    return this.changeValue(mi, lastArgument, new J.Literal(Tree.randomId(), Space.SINGLE_SPACE, Markers.EMPTY, (Object)ChangeVariationDefault.this.defaultValue, ChangeVariationDefault.this.defaultValue, null, JavaType.Primitive.Int));
                }
                if (DOUBLE_VARIATION_MATCHER.matches((MethodCall)mi) && J.Literal.isLiteralValue((Expression)firstArgument, (Object)ChangeVariationDefault.this.featureKey)) {
                    return this.changeValue(mi, lastArgument, new J.Literal(Tree.randomId(), Space.SINGLE_SPACE, Markers.EMPTY, (Object)ChangeVariationDefault.this.defaultValue, ChangeVariationDefault.this.defaultValue, null, JavaType.Primitive.Double));
                }
                return mi;
            }

            private J.MethodInvocation changeValue(J.MethodInvocation mi, Expression existingValue, J.Literal newValue) {
                if (existingValue instanceof J.Literal && newValue.getValueSource().equals(((J.Literal)existingValue).getValueSource())) {
                    return mi;
                }
                return mi.withArguments(ListUtils.mapLast((List)mi.getArguments(), a -> newValue.withPrefix(a.getPrefix())));
            }
        };
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(BOOL_VARIATION_MATCHER), new UsesMethod(STRING_VARIATION_MATCHER), new UsesMethod(INT_VARIATION_MATCHER), new UsesMethod(DOUBLE_VARIATION_MATCHER)}), (TreeVisitor)visitor);
    }

    public ChangeVariationDefault(String featureKey, String defaultValue) {
        this.featureKey = featureKey;
        this.defaultValue = defaultValue;
    }

    public String getFeatureKey() {
        return this.featureKey;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String toString() {
        return "ChangeVariationDefault(featureKey=" + this.getFeatureKey() + ", defaultValue=" + this.getDefaultValue() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeVariationDefault)) {
            return false;
        }
        ChangeVariationDefault other = (ChangeVariationDefault)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$featureKey = this.getFeatureKey();
        String other$featureKey = other.getFeatureKey();
        if (this$featureKey == null ? other$featureKey != null : !this$featureKey.equals(other$featureKey)) {
            return false;
        }
        String this$defaultValue = this.getDefaultValue();
        String other$defaultValue = other.getDefaultValue();
        return !(this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChangeVariationDefault;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $featureKey = this.getFeatureKey();
        result = result * 59 + ($featureKey == null ? 43 : $featureKey.hashCode());
        String $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        return result;
    }
}

