/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.launchdarkly;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public final class MigrateUserToContext
extends Recipe {
    private static final MethodMatcher NEW_USER = new MethodMatcher("com.launchdarkly.sdk.LDUser <constructor>(java.lang.String)");
    private static final MethodMatcher NEW_USER_BUILDER = new MethodMatcher("com.launchdarkly.sdk.LDUser.Builder <constructor>(java.lang.String)");
    private static final List<String> BASIC_ATTRIBUTES = Arrays.asList("avatar", "country", "email", "firstName", "ip", "lastName");
    private static final List<String> PRIVATE_ATTRIBUTES = Arrays.asList("privateAvatar", "privateCountry", "privateEmail", "privateFirstName", "privateIp", "privateLastName", "privateName");
    private static final MethodMatcher BUILTIN_ATTRIBUTE = new MethodMatcher("com.launchdarkly.sdk.LDUser.Builder *(java.lang.String)");
    private static final MethodMatcher BUILTIN_PRIVATE_ATTRIBUTE = new MethodMatcher("com.launchdarkly.sdk.LDUser.Builder private*(java.lang.String)");
    private static final MethodMatcher CUSTOM_ATTRIBUTES = new MethodMatcher("com.launchdarkly.sdk.LDUser.Builder custom(java.lang.String, ..)");
    private static final MethodMatcher PRIVATE_CUSTOM_ATTRIBUTES = new MethodMatcher("com.launchdarkly.sdk.LDUser.Builder privateCustom(java.lang.String, ..)");

    public String getDisplayName() {
        return "Migrate `LDUser` to `LDContext`";
    }

    public String getDescription() {
        return "Migrate from `LDUser` and `LDUser.Builder` to `LDContext` and `ContextBuilder`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("com.launchdarkly.sdk.LDUser", null), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
                if (NEW_USER.matches((MethodCall)newClass)) {
                    this.maybeRemoveImport("com.launchdarkly.sdk.LDUser");
                    this.maybeAddImport("com.launchdarkly.sdk.LDContext");
                    this.doAfterVisit(new ChangeType("com.launchdarkly.sdk.LDUser", "com.launchdarkly.sdk.LDContext", null).getVisitor());
                    return JavaTemplate.builder((String)"LDContext.create(#{any(java.lang.String)})").contextSensitive().javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"launchdarkly-java-server-sdk-6"})).imports(new String[]{"com.launchdarkly.sdk.LDContext"}).build().apply(this.getCursor(), newClass.getCoordinates().replace(), new Object[]{newClass.getArguments().get(0)});
                }
                if (NEW_USER_BUILDER.matches((MethodCall)newClass)) {
                    this.maybeRemoveImport("com.launchdarkly.sdk.LDUser");
                    this.maybeAddImport("com.launchdarkly.sdk.LDContext");
                    this.doAfterVisit(new ChangeType("com.launchdarkly.sdk.LDUser", "com.launchdarkly.sdk.LDContext", null).getVisitor());
                    return JavaTemplate.builder((String)"LDContext.builder(#{any(java.lang.String)})").contextSensitive().javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"launchdarkly-java-server-sdk-6"})).imports(new String[]{"com.launchdarkly.sdk.LDContext"}).build().apply(this.getCursor(), newClass.getCoordinates().replace(), new Object[]{newClass.getArguments().get(0)});
                }
                return super.visitNewClass(newClass, (Object)ctx);
            }

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (BUILTIN_ATTRIBUTE.matches((MethodCall)m) && BASIC_ATTRIBUTES.contains(m.getSimpleName())) {
                    String code = Objects.requireNonNull(m.getPadding().getSelect()).getAfter().getWhitespace().contains("\n") ? "#{any(com.launchdarkly.sdk.ContextBuilder)}\n.set(#{any(java.lang.String)}, #{any()})" : "#{any(com.launchdarkly.sdk.ContextBuilder)}.set(#{any(java.lang.String)}, #{any()})";
                    return JavaTemplate.builder((String)code).contextSensitive().javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"launchdarkly-java-server-sdk-6"})).imports(new String[]{"com.launchdarkly.sdk.ContextBuilder"}).build().apply(this.getCursor(), m.getCoordinates().replace(), new Object[]{m.getSelect(), new J.Literal(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Object)m.getSimpleName(), "\"" + m.getSimpleName() + "\"", null, JavaType.Primitive.String), m.getArguments().get(0)});
                }
                if (BUILTIN_PRIVATE_ATTRIBUTE.matches((MethodCall)m) && PRIVATE_ATTRIBUTES.contains(m.getSimpleName())) {
                    this.doAfterVisit((TreeVisitor)new UseVarargsForPrivateAttributes());
                    String code = Objects.requireNonNull(m.getPadding().getSelect()).getAfter().getWhitespace().contains("\n") ? "#{any(com.launchdarkly.sdk.ContextBuilder)}\n.set(#{any(java.lang.String)}, #{any()})\n.privateAttributes(#{any(java.lang.String)})" : "#{any(com.launchdarkly.sdk.ContextBuilder)}.set(#{any(java.lang.String)}, #{any()}).privateAttributes(#{any(java.lang.String)})";
                    String attributeName = StringUtils.uncapitalize((String)m.getSimpleName().replace("private", ""));
                    return JavaTemplate.builder((String)code).contextSensitive().javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"launchdarkly-java-server-sdk-6"})).imports(new String[]{"com.launchdarkly.sdk.ContextBuilder"}).build().apply(this.getCursor(), m.getCoordinates().replace(), new Object[]{m.getSelect(), new J.Literal(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Object)attributeName, "\"" + attributeName + "\"", null, JavaType.Primitive.String), m.getArguments().get(0), new J.Literal(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Object)attributeName, "\"" + attributeName + "\"", null, JavaType.Primitive.String)});
                }
                if (CUSTOM_ATTRIBUTES.matches((MethodCall)m)) {
                    String code = Objects.requireNonNull(m.getPadding().getSelect()).getAfter().getWhitespace().contains("\n") ? "#{any(com.launchdarkly.sdk.ContextBuilder)}\n.set(#{any(java.lang.String)}, #{any()})" : "#{any(com.launchdarkly.sdk.ContextBuilder)}.set(#{any(java.lang.String)}, #{any()})";
                    return JavaTemplate.builder((String)code).contextSensitive().javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"launchdarkly-java-server-sdk-6"})).imports(new String[]{"com.launchdarkly.sdk.ContextBuilder"}).build().apply(this.getCursor(), m.getCoordinates().replace(), new Object[]{m.getSelect(), m.getArguments().get(0), m.getArguments().get(1)});
                }
                if (PRIVATE_CUSTOM_ATTRIBUTES.matches((MethodCall)m)) {
                    this.doAfterVisit((TreeVisitor)new UseVarargsForPrivateAttributes());
                    String code = Objects.requireNonNull(m.getPadding().getSelect()).getAfter().getWhitespace().contains("\n") ? "#{any(com.launchdarkly.sdk.ContextBuilder)}\n.set(#{any(java.lang.String)}, #{any()})\n.privateAttributes(#{any(java.lang.String)})" : "#{any(com.launchdarkly.sdk.ContextBuilder)}.set(#{any(java.lang.String)}, #{any()}).privateAttributes(#{any(java.lang.String)})";
                    return JavaTemplate.builder((String)code).contextSensitive().javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"launchdarkly-java-server-sdk-6"})).imports(new String[]{"com.launchdarkly.sdk.ContextBuilder"}).build().apply(this.getCursor(), m.getCoordinates().replace(), new Object[]{m.getSelect(), m.getArguments().get(0), m.getArguments().get(1), m.getArguments().get(0)});
                }
                return m;
            }
        });
    }

    public String toString() {
        return "MigrateUserToContext()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MigrateUserToContext)) {
            return false;
        }
        MigrateUserToContext other = (MigrateUserToContext)((Object)o);
        return other.canEqual((Object)this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof MigrateUserToContext;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private static class UseVarargsForPrivateAttributes
    extends JavaIsoVisitor<ExecutionContext> {
        private static final MethodMatcher CONTEXT_BUILDER_MATCHER = new MethodMatcher("com.launchdarkly.sdk.ContextBuilder *(..)");
        private static final MethodMatcher PRIVATE_ATTRIBUTES_STRING_VARARGS_MATCHER = new MethodMatcher("com.launchdarkly.sdk.ContextBuilder privateAttributes(java.lang.String...)");
        private static final MethodMatcher USER_BUILDER_BUILD_MATCHER = new MethodMatcher("com.launchdarkly.sdk.LDUser.Builder build()");
        private static final MethodMatcher CONTEXT_BUILDER_BUILD_MATCHER = new MethodMatcher("com.launchdarkly.sdk.ContextBuilder build()");

        private UseVarargsForPrivateAttributes() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
            if (!USER_BUILDER_BUILD_MATCHER.matches((MethodCall)m) && !CONTEXT_BUILDER_BUILD_MATCHER.matches((MethodCall)m)) {
                return m;
            }
            List<J.MethodInvocation> chain = this.computeChain(m);
            return this.unfold(m, chain);
        }

        private List<J.MethodInvocation> computeChain(J.MethodInvocation build) {
            ArrayList<J.MethodInvocation> chain = new ArrayList<J.MethodInvocation>();
            if (!(build.getSelect() instanceof J.MethodInvocation)) {
                return chain;
            }
            ArrayList<Expression> attributes = new ArrayList<Expression>();
            Expression select = build.getSelect();
            int privateAttributesInvocations = 0;
            int lastPrivateAttributesIdx = -1;
            while (CONTEXT_BUILDER_MATCHER.matches(select)) {
                J.MethodInvocation m = (J.MethodInvocation)select;
                if (PRIVATE_ATTRIBUTES_STRING_VARARGS_MATCHER.matches((MethodCall)m)) {
                    if (lastPrivateAttributesIdx == -1 && CONTEXT_BUILDER_MATCHER.matches(m.getSelect())) {
                        lastPrivateAttributesIdx = chain.size();
                        chain.add(m);
                    }
                    attributes.addAll(0, m.getArguments());
                    ++privateAttributesInvocations;
                } else {
                    chain.add(m);
                }
                select = m.getSelect();
            }
            if (privateAttributesInvocations <= 1) {
                return Collections.emptyList();
            }
            for (int i = 1; i < attributes.size(); ++i) {
                attributes.set(i, (Expression)((Expression)attributes.get(i)).withPrefix(Space.SINGLE_SPACE));
            }
            chain.set(lastPrivateAttributesIdx, ((J.MethodInvocation)chain.get(lastPrivateAttributesIdx)).withArguments(attributes));
            return chain;
        }

        private J.MethodInvocation unfold(J.MethodInvocation build, List<J.MethodInvocation> chain) {
            if (chain.isEmpty()) {
                return build;
            }
            Collections.reverse(chain);
            J.MethodInvocation select = chain.get(0);
            for (int i = 1; i < chain.size(); ++i) {
                select = chain.get(i).withId(Tree.randomId()).withSelect((Expression)select);
            }
            return build.withSelect((Expression)select);
        }
    }
}

