/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.launchdarkly;

import java.util.Optional;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.analysis.constantfold.ConstantFold;
import org.openrewrite.analysis.util.CursorUtil;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;
import org.openrewrite.staticanalysis.RemoveUnusedLocalVariables;
import org.openrewrite.staticanalysis.RemoveUnusedPrivateFields;
import org.openrewrite.staticanalysis.SimplifyConstantIfBranchExecution;

public final class RemoveBoolVariation
extends Recipe {
    private static final String METHOD_PATTERN_BOOLVARIATION = "com.launchdarkly.sdk.server.LDClient boolVariation(String, com.launchdarkly.sdk.*, boolean)";
    @Option(displayName="Feature flag key", description="The key of the feature flag to remove.", example="flag-key-123abc")
    private final String featureKey;
    @Option(displayName="Replacement value", description="The value to replace the feature flag check with.", example="true")
    private final Boolean replacementValue;
    @Option(displayName="Method pattern", description="A method pattern to match against. If not specified, will match `LDClient` `boolVariation`. The first argument must be the feature key as `String`.", example="com.launchdarkly.sdk.server.LDClient boolVariation(String, com.launchdarkly.sdk.*, boolean)", required=false)
    @Nullable
    private final String methodPattern;

    public String getDisplayName() {
        return "Remove `boolVariation` for feature key";
    }

    public String getDescription() {
        return "Replace `boolVariation` invocations for feature key with value, and simplify constant if branch execution.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        String pattern = Optional.ofNullable(this.methodPattern).filter(StringUtils::isNotEmpty).orElse(METHOD_PATTERN_BOOLVARIATION);
        final MethodMatcher methodMatcher = new MethodMatcher(pattern, true);
        JavaVisitor<ExecutionContext> visitor = new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (methodMatcher.matches((MethodCall)mi) && this.isFeatureKey((Expression)mi.getArguments().get(0))) {
                    this.doAfterVisit(new SimplifyConstantIfBranchExecution().getVisitor());
                    this.doAfterVisit(new RemoveUnusedLocalVariables(null).getVisitor());
                    this.doAfterVisit(new RemoveUnusedPrivateFields().getVisitor());
                    return new J.Literal(Tree.randomId(), Space.SINGLE_SPACE, Markers.EMPTY, (Object)RemoveBoolVariation.this.replacementValue, String.valueOf(RemoveBoolVariation.this.replacementValue), null, JavaType.Primitive.Boolean);
                }
                return mi;
            }

            private boolean isFeatureKey(Expression firstArgument) {
                return (Boolean)CursorUtil.findCursorForTree((Cursor)this.getCursor(), (Tree)firstArgument).bind(c -> ConstantFold.findConstantLiteralValue((Cursor)c, String.class)).map(RemoveBoolVariation.this.featureKey::equals).orSome((Object)false);
            }
        };
        return Preconditions.check((TreeVisitor)new UsesMethod(methodMatcher), (TreeVisitor)visitor);
    }

    public RemoveBoolVariation(String featureKey, Boolean replacementValue, String methodPattern) {
        this.featureKey = featureKey;
        this.replacementValue = replacementValue;
        this.methodPattern = methodPattern;
    }

    public String getFeatureKey() {
        return this.featureKey;
    }

    public Boolean getReplacementValue() {
        return this.replacementValue;
    }

    public String getMethodPattern() {
        return this.methodPattern;
    }

    public String toString() {
        return "RemoveBoolVariation(featureKey=" + this.getFeatureKey() + ", replacementValue=" + this.getReplacementValue() + ", methodPattern=" + this.getMethodPattern() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveBoolVariation)) {
            return false;
        }
        RemoveBoolVariation other = (RemoveBoolVariation)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$replacementValue = this.getReplacementValue();
        Boolean other$replacementValue = other.getReplacementValue();
        if (this$replacementValue == null ? other$replacementValue != null : !((Object)this$replacementValue).equals(other$replacementValue)) {
            return false;
        }
        String this$featureKey = this.getFeatureKey();
        String other$featureKey = other.getFeatureKey();
        if (this$featureKey == null ? other$featureKey != null : !this$featureKey.equals(other$featureKey)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        return !(this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RemoveBoolVariation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $replacementValue = this.getReplacementValue();
        result = result * 59 + ($replacementValue == null ? 43 : ((Object)$replacementValue).hashCode());
        String $featureKey = this.getFeatureKey();
        result = result * 59 + ($featureKey == null ? 43 : $featureKey.hashCode());
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        return result;
    }
}

