/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging.logback;

import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.AddImport;
import org.openrewrite.java.ChangeMethodName;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.ImplementInterface;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class Log4jLayoutToLogback
extends Recipe {
    public String getDisplayName() {
        return "Migrate Log4j layout to logback";
    }

    public String getDescription() {
        return "Migrates custom log4j layout components to logback-classic.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType("org.apache.log4j.Layout");
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new Log4jLayoutToLogbackVisitor();
    }

    public static class Log4jLayoutToLogbackVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
            this.doAfterVisit((Recipe)new ChangeMethodName("org.apache.log4j.Layout format(..)", "doLayout"));
            this.doAfterVisit((Recipe)new ChangeMethodName("org.apache.log4j.spi.LoggingEvent getRenderedMessage()", "getMessage"));
            return super.visitCompilationUnit(cu, (Object)ctx);
        }

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
            if (cd.getExtends() != null && cd.getExtends().getType() != null) {
                JavaType.FullyQualified fullyQualifiedExtends = TypeUtils.asFullyQualified((JavaType)cd.getExtends().getType());
                if (fullyQualifiedExtends != null && "org.apache.log4j.Layout".equals(fullyQualifiedExtends.getFullyQualifiedName())) {
                    this.maybeRemoveImport("org.apache.log4j.Layout");
                    this.maybeRemoveImport("org.apache.log4j.LoggingEvent");
                    this.maybeAddImport("ch.qos.logback.core.LayoutBase");
                    this.maybeAddImport("ch.qos.logback.classic.spi.ILoggingEvent");
                    this.doAfterVisit((Recipe)new ChangeType("org.apache.log4j.spi.LoggingEvent", "ch.qos.logback.classic.spi.ILoggingEvent"));
                    cd = (J.ClassDeclaration)cd.withTemplate(this.template("LayoutBase<ILoggingEvent>").imports(new String[]{"ch.qos.logback.core.LayoutBase", "ch.qos.logback.classic.spi.ILoggingEvent"}).build(), cd.getCoordinates().replaceExtendsClause(), new Object[0]);
                    this.doAfterVisit((TreeVisitor)new AddImport("ch.qos.logback.core.LayoutBase", null, false));
                }
                cd = cd.withBody(cd.getBody().withStatements(ListUtils.map((List)cd.getBody().getStatements(), statement -> {
                    if (statement instanceof J.MethodDeclaration) {
                        J.MethodDeclaration method = (J.MethodDeclaration)statement;
                        if ("ignoresThrowable".equals(method.getSimpleName())) {
                            return null;
                        }
                        if ("activateOptions".equals(method.getSimpleName())) {
                            if (method.getBody() != null && method.getBody().getStatements().isEmpty()) {
                                return null;
                            }
                            J.ClassDeclaration enclosingClass = (J.ClassDeclaration)this.getCursor().firstEnclosing(J.ClassDeclaration.class);
                            assert (enclosingClass != null);
                            this.doAfterVisit((TreeVisitor)new ImplementInterface(enclosingClass, "ch.qos.logback.core.spi.LifeCycle"));
                            return method.withName(method.getName().withName("start"));
                        }
                    }
                    return statement;
                })));
            }
            return cd;
        }
    }
}

