/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging.slf4j;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.template.SourceTemplate;

public class ParameterizedLogging
extends Recipe {
    private static final List<MethodMatcher> LOG_LEVEL_MATCHERS = Stream.of("trace", "debug", "info", "warn", "error").map(level -> "org.slf4j.Logger " + level + "(..)").map(MethodMatcher::new).collect(Collectors.toList());

    private static MessageAndArguments concatenationToLiteral(Expression message, MessageAndArguments result) {
        if (!(message instanceof J.Binary)) {
            result.arguments.add(message);
            return result;
        }
        J.Binary concat = (J.Binary)message;
        if (concat.getLeft() instanceof J.Binary && ((J.Binary)concat.getLeft()).getOperator() == J.Binary.Type.Addition) {
            ParameterizedLogging.concatenationToLiteral(concat.getLeft(), result);
        } else if (concat.getLeft() instanceof J.Literal) {
            result.message = ((J.Literal)concat.getLeft()).getValue() + result.message;
        } else {
            result.message = "{}" + result.message;
            result.arguments.add(concat.getLeft());
        }
        if (concat.getRight() instanceof J.Binary && ((J.Binary)concat.getRight()).getOperator() == J.Binary.Type.Addition) {
            ParameterizedLogging.concatenationToLiteral(concat.getRight(), result);
        } else if (concat.getRight() instanceof J.Literal) {
            result.message = result.message + ((J.Literal)concat.getRight()).getValue();
        } else {
            if (result.message.endsWith("#")) {
                result.message = result.message + "\\";
            }
            result.message = result.message + "{}";
            result.arguments.add(concat.getRight());
        }
        return result;
    }

    public String getDisplayName() {
        return "Parameterize SLF4J logging statements";
    }

    public String getDescription() {
        return "SLF4J supports parameterized logging which can significantly boost logging performance for disabled logging statement.";
    }

    @Nullable
    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType("org.slf4j.Logger");
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new ParameterizedLoggingVisitor();
    }

    private static class MessageAndArguments {
        private final List<Expression> arguments;
        private String message;

        private MessageAndArguments(String message, List<Expression> arguments) {
            this.message = message;
            this.arguments = arguments;
        }
    }

    private static class ParameterizedLoggingVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private ParameterizedLoggingVisitor() {
        }

        private static String escapeJava(String value) {
            return value.replace("\"", "\\\\\"").replace("\r", "\\\\r").replace("\n", "\\\\n").replace("\t", "\\\\t");
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
            if (LOG_LEVEL_MATCHERS.stream().anyMatch(it -> it.matches(method)) && !method.getArguments().isEmpty() && !(method.getArguments().get(0) instanceof J.Empty) && method.getArguments().size() <= 2 && method.getArguments().get(0) instanceof J.Binary) {
                StringBuilder messageBuilder = new StringBuilder("\"");
                ArrayList newArgList = new ArrayList();
                ListUtils.map((List)method.getArguments(), (index, message) -> {
                    if (index == 0 && message instanceof J.Binary) {
                        MessageAndArguments literalAndArgs = ParameterizedLogging.concatenationToLiteral(message, new MessageAndArguments("", new ArrayList()));
                        messageBuilder.append(ParameterizedLoggingVisitor.escapeJava(literalAndArgs.message));
                        newArgList.addAll(literalAndArgs.arguments);
                    } else {
                        newArgList.add(message);
                    }
                    return message;
                });
                messageBuilder.append("\"");
                newArgList.forEach(arg -> messageBuilder.append(", #{any()}"));
                m = (J.MethodInvocation)m.withTemplate((SourceTemplate)JavaTemplate.builder(() -> ((ParameterizedLoggingVisitor)this).getCursor(), (String)messageBuilder.toString()).build(), m.getCoordinates().replaceArguments(), newArgList.toArray());
            }
            return m;
        }
    }
}

