/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging;

import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.FindFields;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.template.SourceTemplate;

public class PrintStackTraceToLogError
extends Recipe {
    public String getDisplayName() {
        return "Use logger instead of `printStackTrace()`";
    }

    public String getDescription() {
        return "When a logger is present, log exceptions rather than calling `printStackTrace()`.";
    }

    protected JavaVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        return new JavaVisitor<ExecutionContext>(){

            public J visitCompilationUnit(J.CompilationUnit cu, ExecutionContext executionContext) {
                this.doAfterVisit((TreeVisitor)new UsesType("org.slf4j.Logger"));
                this.doAfterVisit((TreeVisitor)new UsesType("org.apache.log4j.Category"));
                return cu;
            }
        };
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher printStackTrace = new MethodMatcher("java.lang.Throwable printStackTrace()");
        return new JavaVisitor<ExecutionContext>(){
            final JavaTemplate slf4jError = JavaTemplate.builder(() -> (this).getCursor(), (String)"#{any(org.slf4j.Logger)}.error(\"Exception\", #{any(java.lang.Throwable)}").javaParser(() -> JavaParser.fromJavaVersion().dependsOn(new String[]{"package org.slf4j;public interface Logger {    void error(String msg, Throwable t);}"}).build()).build();
            final JavaTemplate log4jError = JavaTemplate.builder(() -> (this).getCursor(), (String)"#{any(org.apache.log4j.Category)}.error(\"Exception\", #{any(java.lang.Throwable)}").javaParser(() -> JavaParser.fromJavaVersion().dependsOn(new String[]{"package org.apache.log4j;public interface Category {    void error(Object msg, Throwable t);}"}).build()).build();

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                if (printStackTrace.matches(method)) {
                    J.ClassDeclaration clazz = (J.ClassDeclaration)this.getCursor().firstEnclosingOrThrow(J.ClassDeclaration.class);
                    Set slf4jLoggers = FindFields.find((J)clazz, (String)"org.slf4j.Logger");
                    if (!slf4jLoggers.isEmpty()) {
                        return method.withTemplate((SourceTemplate)this.slf4jError, method.getCoordinates().replace(), new Object[]{((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)slf4jLoggers.iterator().next()).getVariables().get(0)).getName(), method.getSelect()});
                    }
                    Set log4jLoggers = FindFields.find((J)clazz, (String)"org.apache.log4j.Category");
                    if (!log4jLoggers.isEmpty()) {
                        return method.withTemplate((SourceTemplate)this.log4jError, method.getCoordinates().replace(), new Object[]{((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)log4jLoggers.iterator().next()).getVariables().get(0)).getName(), method.getSelect()});
                    }
                }
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
        };
    }
}

