/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging.logback;

import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.AddImport;
import org.openrewrite.java.ChangeMethodName;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.template.SourceTemplate;

public class Log4jAppenderToLogback
extends Recipe {
    public String getDisplayName() {
        return "Migrate from Log4j appender";
    }

    public String getDescription() {
        return "Migrates custom Log4j appender components to `logback-classic`.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType("org.apache.log4j.AppenderSkeleton");
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new Log4jAppenderToLogbackVisitor();
    }

    public static class Log4jAppenderToLogbackVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
            this.doAfterVisit((Recipe)new ChangeMethodName("org.apache.log4j.Layout format(..)", "doLayout", null));
            return super.visitCompilationUnit(cu, (Object)ctx);
        }

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
            if (cd.getExtends() != null && cd.getExtends().getType() != null) {
                JavaType.FullyQualified fullyQualifiedExtends = TypeUtils.asFullyQualified((JavaType)cd.getExtends().getType());
                if (fullyQualifiedExtends != null && "org.apache.log4j.AppenderSkeleton".equals(fullyQualifiedExtends.getFullyQualifiedName())) {
                    this.maybeRemoveImport("org.apache.log4j.AppenderSkeleton");
                    this.maybeAddImport("ch.qos.logback.core.AppenderBase");
                    this.maybeAddImport("ch.qos.logback.classic.spi.ILoggingEvent");
                    this.doAfterVisit((Recipe)new ChangeType("org.apache.log4j.spi.LoggingEvent", "ch.qos.logback.classic.spi.ILoggingEvent"));
                    this.doAfterVisit((Recipe)new ChangeType("org.apache.log4j.Layout", "ch.qos.logback.core.LayoutBase"));
                    cd = (J.ClassDeclaration)cd.withTemplate((SourceTemplate)JavaTemplate.builder(() -> ((Log4jAppenderToLogbackVisitor)this).getCursor(), (String)"AppenderBase<ILoggingEvent>").imports(new String[]{"ch.qos.logback.core.AppenderBase", "ch.qos.logback.classic.spi.ILoggingEvent"}).build(), cd.getCoordinates().replaceExtendsClause(), new Object[0]);
                    this.doAfterVisit((TreeVisitor)new AddImport("ch.qos.logback.core.AppenderBase", null, false));
                }
                cd = cd.withBody(cd.getBody().withStatements(ListUtils.map((List)cd.getBody().getStatements(), statement -> {
                    if (statement instanceof J.MethodDeclaration) {
                        J.MethodDeclaration method = (J.MethodDeclaration)statement;
                        if ("requiresLayout".equals(method.getSimpleName())) {
                            return null;
                        }
                        if ("close".equals(method.getSimpleName())) {
                            if (method.getBody() != null && method.getBody().getStatements().isEmpty()) {
                                return null;
                            }
                            return method.withName(method.getName().withName("stop"));
                        }
                    }
                    return statement;
                })));
            }
            return cd;
        }
    }
}

