/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging.slf4j;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.ChangeMethodName;
import org.openrewrite.java.ChangeMethodTargetToStatic;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.logging.slf4j.ParameterizedLogging;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.template.SourceTemplate;

public class Log4jToSlf4j
extends Recipe {
    public String getDisplayName() {
        return "Migrate Log4j logging framework to SLF4J";
    }

    public String getDescription() {
        return "Use of the traditional Log4j to SLF4J bridge can result in some loss of performance as the Log4j 2 Messages must be formatted before they can be passed to SLF4J.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext executionContext) {
                this.doAfterVisit((TreeVisitor)new UsesType("org.apache.log4j.Logger"));
                this.doAfterVisit((TreeVisitor)new UsesType("org.apache.log4j.Category"));
                return cu;
            }
        };
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new Log4jToSlf4jVisitor();
    }

    private static class Log4jToSlf4jVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final List<MethodMatcher> logLevelMatchers = Stream.of("trace", "debug", "info", "warn", "error", "fatal").map(level -> "org.apache.log4j." + (level.equals("trace") ? "Logger" : "Category") + " " + level + "(..)").map(MethodMatcher::new).collect(Collectors.toList());

        private Log4jToSlf4jVisitor() {
        }

        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
            J.CompilationUnit c = super.visitCompilationUnit(cu, (Object)ctx);
            this.doAfterVisit((Recipe)new ChangeMethodTargetToStatic("org.apache.log4j.Logger getLogger(..)", "org.slf4j.LoggerFactory", "org.slf4j.Logger", null));
            this.doAfterVisit((Recipe)new ChangeMethodTargetToStatic("org.apache.log4j.LogManager getLogger(..)", "org.slf4j.LoggerFactory", "org.slf4j.Logger", null));
            this.doAfterVisit((Recipe)new ChangeMethodName("org.apache.log4j.Category fatal(..)", "error", null));
            this.doAfterVisit((Recipe)new ChangeType("org.apache.log4j.Logger", "org.slf4j.Logger"));
            this.doAfterVisit((Recipe)new ChangeType("org.apache.log4j.Category", "org.slf4j.Logger"));
            this.doAfterVisit(new ParameterizedLogging());
            return c;
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
            for (MethodMatcher matcher : this.logLevelMatchers) {
                Expression message;
                List args;
                if (!matcher.matches(m) || (args = m.getArguments()).isEmpty() || TypeUtils.isString((JavaType)(message = (Expression)args.iterator().next()).getType()) || !(message.getType() instanceof JavaType.Class) && !(message.getType() instanceof JavaType.Method)) continue;
                StringBuilder messageBuilder = new StringBuilder("\"{}\"");
                m.getArguments().forEach(arg -> messageBuilder.append(", #{any()}"));
                m = (J.MethodInvocation)m.withTemplate((SourceTemplate)JavaTemplate.builder(() -> ((Log4jToSlf4jVisitor)this).getCursor(), (String)messageBuilder.toString()).build(), m.getCoordinates().replaceArguments(), m.getArguments().toArray());
            }
            return m;
        }
    }
}

