/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging.slf4j;

import java.beans.ConstructorProperties;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.template.SourceTemplate;

public final class ConvertLogMessageMessageOnlyToLogMessageAndThrowable
extends Recipe {
    @Option(displayName="Log message", description="The message accompanying the exception.", required=false)
    @Nullable
    private final String logMessage;

    public String getDisplayName() {
        return "Convert Logger#error|warn(Throwable#message) to Logger#error|warn(<log-message>, e)";
    }

    public String getDescription() {
        return "Convert `Logger#error|warn(throwable#message)` to `Logger#error|warn(<log-message>, e)` invocations having only the error's message as the parameter, to a log statement with message and throwable";
    }

    protected UsesType<ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType("org.slf4j.Logger");
    }

    protected JavaIsoVisitor<ExecutionContext> getVisitor() {
        final MethodMatcher logErrorMatcher = new MethodMatcher("org.slf4j.Logger error(String)");
        final MethodMatcher logWarningMatcher = new MethodMatcher("org.slf4j.Logger warn(String)");
        final MethodMatcher getMessageMatcher = new MethodMatcher("java.lang.Throwable getMessage()");
        final MethodMatcher getLocalizedMessageMatcher = new MethodMatcher("java.lang.Throwable getLocalizedMessage()");
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)executionContext);
                if ((logErrorMatcher.matches(mi) || logWarningMatcher.matches(mi)) && mi.getArguments().get(0) instanceof J.MethodInvocation && (getMessageMatcher.matches((Expression)mi.getArguments().get(0)) || getLocalizedMessageMatcher.matches((Expression)mi.getArguments().get(0)))) {
                    Expression throwableMessage = ((J.MethodInvocation)mi.getArguments().get(0)).getSelect();
                    String type = mi.getSimpleName();
                    String message = ConvertLogMessageMessageOnlyToLogMessageAndThrowable.this.logMessage == null ? "" : ConvertLogMessageMessageOnlyToLogMessageAndThrowable.this.logMessage;
                    mi = (J.MethodInvocation)mi.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)"#{any(org.slf4j.Logger)}.#{}(\"#{}\", #{any(java.lang.Throwable)}").javaParser(() -> JavaParser.fromJavaVersion().classpath(new String[]{"slf4j-api"}).build()).build(), mi.getCoordinates().replace(), new Object[]{mi.getSelect(), type, message, throwableMessage});
                }
                return mi;
            }
        };
    }

    @ConstructorProperties(value={"logMessage"})
    public ConvertLogMessageMessageOnlyToLogMessageAndThrowable(@Nullable String logMessage) {
        this.logMessage = logMessage;
    }

    @Nullable
    public String getLogMessage() {
        return this.logMessage;
    }

    @NonNull
    public String toString() {
        return "ConvertLogMessageMessageOnlyToLogMessageAndThrowable(logMessage=" + this.getLogMessage() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConvertLogMessageMessageOnlyToLogMessageAndThrowable)) {
            return false;
        }
        ConvertLogMessageMessageOnlyToLogMessageAndThrowable other = (ConvertLogMessageMessageOnlyToLogMessageAndThrowable)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$logMessage = this.getLogMessage();
        String other$logMessage = other.getLogMessage();
        return !(this$logMessage == null ? other$logMessage != null : !this$logMessage.equals(other$logMessage));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ConvertLogMessageMessageOnlyToLogMessageAndThrowable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $logMessage = this.getLogMessage();
        result = result * 59 + ($logMessage == null ? 43 : $logMessage.hashCode());
        return result;
    }
}

