/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging.slf4j;

import java.time.Duration;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.template.SourceTemplate;

public class Slf4jLogShouldBeConstant
extends Recipe {
    private static final MethodMatcher SLF4J_LOG = new MethodMatcher("org.slf4j.Logger *(..)");
    private static final MethodMatcher STRING_FORMAT = new MethodMatcher("java.lang.String format(..)");
    private static final MethodMatcher STRING_VALUE_OF = new MethodMatcher("java.lang.String valueOf(..)");

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public String getDisplayName() {
        return "SLF4J logging statements should begin with constants.";
    }

    public String getDescription() {
        return "Logging statements shouldn't begin with `String#format`, calls to `toString()`, etc.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesMethod(SLF4J_LOG);
    }

    protected JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                String name;
                if (SLF4J_LOG.matches(method) && ("trace".equals(name = method.getSimpleName()) || "debug".equals(name) || "info".equals(name) || "warn".equals(name) || "error".equals(name))) {
                    List args = method.getArguments();
                    if (STRING_FORMAT.matches((Expression)args.get(0))) {
                        J.MethodInvocation stringFormat = (J.MethodInvocation)args.get(0);
                        return method.withArguments(ListUtils.map((List)stringFormat.getArguments(), (n, arg) -> {
                            J.Literal str;
                            if (n == 0 && (str = (J.Literal)arg).getValue() != null && str.getValueSource() != null) {
                                return str.withValue((Object)str.getValue().toString().replace("%s", "{}")).withValueSource(str.getValueSource().replace("%s", "{}"));
                            }
                            return arg;
                        }));
                    }
                    if (STRING_VALUE_OF.matches((Expression)args.get(0))) {
                        Expression valueOf = (Expression)((J.MethodInvocation)args.get(0)).getArguments().get(0);
                        if (TypeUtils.isAssignableTo((JavaType)JavaType.ShallowClass.build((String)"java.lang.Throwable"), (JavaType)valueOf.getType())) {
                            J.MethodInvocation m = (J.MethodInvocation)method.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)"\"Exception\", #{any()}").build(), method.getCoordinates().replaceArguments(), new Object[]{valueOf});
                            m = m.withSelect(method.getSelect());
                            return m;
                        }
                    } else if (args.get(0) instanceof J.MethodInvocation && "toString".equals(((J.MethodInvocation)args.get(0)).getSimpleName())) {
                        Expression valueOf = ((J.MethodInvocation)args.get(0)).getSelect();
                        J.MethodInvocation m = (J.MethodInvocation)method.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)"\"{}\", #{any()}").build(), method.getCoordinates().replaceArguments(), new Object[]{valueOf});
                        m = m.withSelect(method.getSelect());
                        return m;
                    }
                }
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
        };
    }
}

