/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging;

import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.logging.AddLogger;
import org.openrewrite.java.logging.LoggingFramework;
import org.openrewrite.java.logging.ParameterizedLogging;
import org.openrewrite.java.search.FindFieldsOfType;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.template.SourceTemplate;

public final class SystemErrToLogging
extends Recipe {
    private static final MethodMatcher systemErrPrint = new MethodMatcher("java.io.PrintStream print*(String)");
    private static final MethodMatcher printStackTrace = new MethodMatcher("java.lang.Throwable printStackTrace(..)");
    @Option(displayName="Add logger", description="Add a logger field to the class if it isn't already present.", required=false)
    @Nullable
    private final Boolean addLogger;
    @Option(displayName="Logger name", description="The name of the logger to use when generating a field.", required=false)
    @Nullable
    private final String loggerName;
    @Option(displayName="Logging framework", description="The logging framework to use.", valid={"SLF4J", "Log4J", "Log4J2", "JUL"}, required=false)
    @Nullable
    private final String loggingFramework;

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public String getDisplayName() {
        return "Use logger instead of system print statements";
    }

    public String getDescription() {
        return "Replace `System.err` print statements with a logger.";
    }

    protected JavaVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        if (this.addLogger != null && this.addLogger.booleanValue()) {
            return null;
        }
        return new JavaVisitor<ExecutionContext>(){

            public J visitCompilationUnit(J.CompilationUnit cu, ExecutionContext executionContext) {
                this.doAfterVisit((TreeVisitor)new UsesMethod(systemErrPrint));
                return cu;
            }
        };
    }

    public JavaVisitor<ExecutionContext> getVisitor() {
        final LoggingFramework framework = LoggingFramework.fromOption(this.loggingFramework);
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.Block visitBlock(J.Block block, ExecutionContext ctx) {
                J.Block b = super.visitBlock(block, (Object)ctx);
                AtomicBoolean addedLogger = new AtomicBoolean(false);
                AtomicInteger skip = new AtomicInteger(-1);
                b = b.withStatements(ListUtils.map((List)b.getStatements(), (i, stat) -> {
                    if (skip.get() == i.intValue()) {
                        return null;
                    }
                    if (stat instanceof J.MethodInvocation) {
                        JavaType.Variable field;
                        J.MethodInvocation m = (J.MethodInvocation)stat;
                        if (systemErrPrint.matches((Expression)stat) && m.getSelect() != null && m.getSelect() instanceof J.FieldAccess && (field = ((J.FieldAccess)m.getSelect()).getName().getFieldType()) != null && "err".equals(field.getName()) && TypeUtils.isOfClassType((JavaType)field.getOwner(), (String)"java.lang.System")) {
                            J.MethodInvocation unchangedIfAddedLogger;
                            J next;
                            Expression exceptionPrintStackTrace = null;
                            if (block.getStatements().size() > i + 1 && (next = (J)block.getStatements().get(i + 1)) instanceof J.MethodInvocation && printStackTrace.matches((Expression)next)) {
                                exceptionPrintStackTrace = ((J.MethodInvocation)next).getSelect();
                                skip.set(i + 1);
                            }
                            addedLogger.set((unchangedIfAddedLogger = this.logInsteadOfPrint(m, ctx, exceptionPrintStackTrace)) == m);
                            return unchangedIfAddedLogger;
                        }
                    }
                    return stat;
                }));
                return addedLogger.get() ? block : b;
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                JavaType.Variable field;
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                if (systemErrPrint.matches((Expression)method) && this.getCursor().getParentOrThrow().getValue() instanceof J.Lambda && m.getSelect() != null && m.getSelect() instanceof J.FieldAccess && (field = ((J.FieldAccess)m.getSelect()).getName().getFieldType()) != null && "err".equals(field.getName()) && TypeUtils.isOfClassType((JavaType)field.getOwner(), (String)"java.lang.System")) {
                    return this.logInsteadOfPrint(m, ctx, null);
                }
                return m;
            }

            private J.MethodInvocation logInsteadOfPrint(J.MethodInvocation print, ExecutionContext ctx, @Nullable Expression exceptionPrintStackTrace) {
                J.ClassDeclaration clazz = (J.ClassDeclaration)this.getCursor().firstEnclosingOrThrow(J.ClassDeclaration.class);
                Set loggers = FindFieldsOfType.find((J)clazz, (String)framework.getLoggerType());
                if (!loggers.isEmpty()) {
                    J.Identifier computedLoggerName = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)loggers.iterator().next()).getVariables().get(0)).getName();
                    print = exceptionPrintStackTrace == null ? (J.MethodInvocation)print.withTemplate((SourceTemplate)this.getErrorTemplateNoException((JavaVisitor)this), print.getCoordinates().replace(), new Object[]{computedLoggerName, print.getArguments().get(0)}) : (J.MethodInvocation)print.withTemplate((SourceTemplate)framework.getErrorTemplate(this, "#{any(String)}"), print.getCoordinates().replace(), new Object[]{computedLoggerName, print.getArguments().get(0), exceptionPrintStackTrace});
                    print = (J.MethodInvocation)new ParameterizedLogging(framework.getLoggerType() + " error(..)", false).getVisitor().visitNonNull((Tree)print, (Object)ctx, this.getCursor());
                    if (framework == LoggingFramework.JUL) {
                        this.maybeAddImport("java.util.logging.Level");
                    }
                } else if (SystemErrToLogging.this.addLogger != null && SystemErrToLogging.this.addLogger.booleanValue()) {
                    this.doAfterVisit(AddLogger.addLogger(clazz, framework, SystemErrToLogging.this.loggerName == null ? "logger" : SystemErrToLogging.this.loggerName));
                    this.doAfterVisit((TreeVisitor)this);
                }
                return print;
            }

            public <P> JavaTemplate getErrorTemplateNoException(JavaVisitor<P> visitor) {
                switch (framework) {
                    case SLF4J: {
                        return JavaTemplate.builder(() -> visitor.getCursor(), (String)"#{any(org.slf4j.Logger)}.error(#{any(String)})").javaParser(() -> JavaParser.fromJavaVersion().classpath(new String[]{"slf4j-api"}).build()).build();
                    }
                    case Log4J1: {
                        return JavaTemplate.builder(() -> visitor.getCursor(), (String)"#{any(org.apache.log4j.Category)}.error(#{any(String)})").javaParser(() -> JavaParser.fromJavaVersion().classpath(new String[]{"log4j"}).build()).build();
                    }
                    case Log4J2: {
                        return JavaTemplate.builder(() -> visitor.getCursor(), (String)"#{any(org.apache.logging.log4j.Logger)}.error(#{any(String)})").javaParser(() -> JavaParser.fromJavaVersion().classpath(new String[]{"log4j-api"}).build()).build();
                    }
                }
                return JavaTemplate.builder(() -> visitor.getCursor(), (String)"#{any(java.util.logging.Logger)}.log(Level.SEVERE, #{any(String)})").imports(new String[]{"java.util.logging.Level"}).build();
            }
        };
    }

    @ConstructorProperties(value={"addLogger", "loggerName", "loggingFramework"})
    public SystemErrToLogging(@Nullable Boolean addLogger, @Nullable String loggerName, @Nullable String loggingFramework) {
        this.addLogger = addLogger;
        this.loggerName = loggerName;
        this.loggingFramework = loggingFramework;
    }

    @Nullable
    public Boolean getAddLogger() {
        return this.addLogger;
    }

    @Nullable
    public String getLoggerName() {
        return this.loggerName;
    }

    @Nullable
    public String getLoggingFramework() {
        return this.loggingFramework;
    }

    @NonNull
    public String toString() {
        return "SystemErrToLogging(addLogger=" + this.getAddLogger() + ", loggerName=" + this.getLoggerName() + ", loggingFramework=" + this.getLoggingFramework() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SystemErrToLogging)) {
            return false;
        }
        SystemErrToLogging other = (SystemErrToLogging)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$addLogger = this.getAddLogger();
        Boolean other$addLogger = other.getAddLogger();
        if (this$addLogger == null ? other$addLogger != null : !((Object)this$addLogger).equals(other$addLogger)) {
            return false;
        }
        String this$loggerName = this.getLoggerName();
        String other$loggerName = other.getLoggerName();
        if (this$loggerName == null ? other$loggerName != null : !this$loggerName.equals(other$loggerName)) {
            return false;
        }
        String this$loggingFramework = this.getLoggingFramework();
        String other$loggingFramework = other.getLoggingFramework();
        return !(this$loggingFramework == null ? other$loggingFramework != null : !this$loggingFramework.equals(other$loggingFramework));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof SystemErrToLogging;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $addLogger = this.getAddLogger();
        result = result * 59 + ($addLogger == null ? 43 : ((Object)$addLogger).hashCode());
        String $loggerName = this.getLoggerName();
        result = result * 59 + ($loggerName == null ? 43 : $loggerName.hashCode());
        String $loggingFramework = this.getLoggingFramework();
        result = result * 59 + ($loggingFramework == null ? 43 : $loggingFramework.hashCode());
        return result;
    }
}

