/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging;

import java.beans.ConstructorProperties;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.logging.AddLogger;
import org.openrewrite.java.logging.LoggingFramework;
import org.openrewrite.java.logging.ParameterizedLogging;
import org.openrewrite.java.search.FindFieldsOfType;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.template.SourceTemplate;

public final class SystemOutToLogging
extends Recipe {
    private static final MethodMatcher systemOutPrint = new MethodMatcher("java.io.PrintStream print*(String)");
    @Option(displayName="Add logger", description="Add a logger field to the class if it isn't already present.", required=false)
    @Nullable
    private final Boolean addLogger;
    @Option(displayName="Logger name", description="The name of the logger to use when generating a field.", required=false)
    @Nullable
    private final String loggerName;
    @Option(displayName="Logging framework", description="The logging framework to use.", valid={"SLF4J", "Log4J", "Log4J2", "JUL"}, required=false)
    @Nullable
    private final String loggingFramework;
    @Option(displayName="Level", description="The logging level to turn `System.out` print statements into.", valid={"trace", "debug", "info"}, required=false)
    @Nullable
    private final String level;

    public String getDisplayName() {
        return "Use logger instead of system print statements";
    }

    public String getDescription() {
        return "Replace `System.out` print statements with a logger.";
    }

    protected JavaVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        if (this.addLogger != null && this.addLogger.booleanValue()) {
            return null;
        }
        return new JavaVisitor<ExecutionContext>(){

            public J visitCompilationUnit(J.CompilationUnit cu, ExecutionContext executionContext) {
                this.doAfterVisit((TreeVisitor)new UsesMethod(systemOutPrint));
                return cu;
            }
        };
    }

    public JavaVisitor<ExecutionContext> getVisitor() {
        final LoggingFramework framework = LoggingFramework.fromOption(this.loggingFramework);
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                JavaType.Variable field;
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                if (systemOutPrint.matches((Expression)method) && m.getSelect() != null && m.getSelect() instanceof J.FieldAccess && (field = ((J.FieldAccess)m.getSelect()).getName().getFieldType()) != null && field.getName().equals("out") && TypeUtils.isOfClassType((JavaType)field.getOwner(), (String)"java.lang.System")) {
                    return this.logInsteadOfPrint(m, ctx);
                }
                return m;
            }

            private J.MethodInvocation logInsteadOfPrint(J.MethodInvocation print, ExecutionContext ctx) {
                J.ClassDeclaration clazz = (J.ClassDeclaration)this.getCursor().firstEnclosingOrThrow(J.ClassDeclaration.class);
                Set loggers = FindFieldsOfType.find((J)clazz, (String)framework.getLoggerType());
                if (!loggers.isEmpty()) {
                    J.Identifier computedLoggerName = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)loggers.iterator().next()).getVariables().get(0)).getName();
                    print = (J.MethodInvocation)print.withTemplate((SourceTemplate)this.getInfoTemplate((JavaVisitor)this), print.getCoordinates().replace(), new Object[]{computedLoggerName, print.getArguments().get(0)});
                    print = (J.MethodInvocation)new ParameterizedLogging(framework.getLoggerType() + " " + this.getLevel() + "(..)").getVisitor().visitNonNull((Tree)print, (Object)ctx, this.getCursor());
                    if (framework == LoggingFramework.JUL) {
                        this.maybeAddImport("java.util.logging.Level");
                    }
                } else if (SystemOutToLogging.this.addLogger != null && SystemOutToLogging.this.addLogger.booleanValue()) {
                    this.doAfterVisit(AddLogger.addLogger(clazz, framework, SystemOutToLogging.this.loggerName == null ? "logger" : SystemOutToLogging.this.loggerName));
                    this.doAfterVisit((TreeVisitor)this);
                }
                return print;
            }

            private <P> JavaTemplate getInfoTemplate(JavaVisitor<P> visitor) {
                String levelOrDefault = this.getLevel();
                switch (framework) {
                    case SLF4J: {
                        return JavaTemplate.builder(() -> visitor.getCursor(), (String)("#{any(org.slf4j.Logger)}." + levelOrDefault + "(#{any(String)})")).javaParser(() -> JavaParser.fromJavaVersion().classpath(new String[]{"slf4j-api"}).build()).build();
                    }
                    case Log4J1: {
                        return JavaTemplate.builder(() -> visitor.getCursor(), (String)("#{any(org.apache.log4j.Category)}." + levelOrDefault + "(#{any(String)})")).javaParser(() -> JavaParser.fromJavaVersion().classpath(new String[]{"log4j"}).build()).build();
                    }
                    case Log4J2: {
                        return JavaTemplate.builder(() -> visitor.getCursor(), (String)("#{any(org.apache.logging.log4j.Logger)}." + levelOrDefault + "(#{any(String)})")).javaParser(() -> JavaParser.fromJavaVersion().classpath(new String[]{"log4j-api"}).build()).build();
                    }
                }
                return JavaTemplate.builder(() -> visitor.getCursor(), (String)("#{any(java.util.logging.Logger)}.log(Level." + levelOrDefault + ", #{any(String)})")).imports(new String[]{"java.util.logging.Level"}).build();
            }

            private String getLevel() {
                String levelOrDefault;
                String string = levelOrDefault = SystemOutToLogging.this.level == null ? "info" : SystemOutToLogging.this.level;
                if (framework == LoggingFramework.JUL) {
                    String julLevel = levelOrDefault.toUpperCase();
                    if (levelOrDefault.equals("debug")) {
                        julLevel = "FINE";
                    } else if (levelOrDefault.equals("trace")) {
                        julLevel = "FINER";
                    }
                    return julLevel;
                }
                return levelOrDefault;
            }
        };
    }

    @ConstructorProperties(value={"addLogger", "loggerName", "loggingFramework", "level"})
    public SystemOutToLogging(@Nullable Boolean addLogger, @Nullable String loggerName, @Nullable String loggingFramework, @Nullable String level) {
        this.addLogger = addLogger;
        this.loggerName = loggerName;
        this.loggingFramework = loggingFramework;
        this.level = level;
    }

    @Nullable
    public Boolean getAddLogger() {
        return this.addLogger;
    }

    @Nullable
    public String getLoggerName() {
        return this.loggerName;
    }

    @Nullable
    public String getLoggingFramework() {
        return this.loggingFramework;
    }

    @Nullable
    public String getLevel() {
        return this.level;
    }

    @NonNull
    public String toString() {
        return "SystemOutToLogging(addLogger=" + this.getAddLogger() + ", loggerName=" + this.getLoggerName() + ", loggingFramework=" + this.getLoggingFramework() + ", level=" + this.getLevel() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SystemOutToLogging)) {
            return false;
        }
        SystemOutToLogging other = (SystemOutToLogging)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$addLogger = this.getAddLogger();
        Boolean other$addLogger = other.getAddLogger();
        if (this$addLogger == null ? other$addLogger != null : !((Object)this$addLogger).equals(other$addLogger)) {
            return false;
        }
        String this$loggerName = this.getLoggerName();
        String other$loggerName = other.getLoggerName();
        if (this$loggerName == null ? other$loggerName != null : !this$loggerName.equals(other$loggerName)) {
            return false;
        }
        String this$loggingFramework = this.getLoggingFramework();
        String other$loggingFramework = other.getLoggingFramework();
        if (this$loggingFramework == null ? other$loggingFramework != null : !this$loggingFramework.equals(other$loggingFramework)) {
            return false;
        }
        String this$level = this.getLevel();
        String other$level = other.getLevel();
        return !(this$level == null ? other$level != null : !this$level.equals(other$level));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof SystemOutToLogging;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $addLogger = this.getAddLogger();
        result = result * 59 + ($addLogger == null ? 43 : ((Object)$addLogger).hashCode());
        String $loggerName = this.getLoggerName();
        result = result * 59 + ($loggerName == null ? 43 : $loggerName.hashCode());
        String $loggingFramework = this.getLoggingFramework();
        result = result * 59 + ($loggingFramework == null ? 43 : $loggingFramework.hashCode());
        String $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : $level.hashCode());
        return result;
    }
}

