/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging.slf4j;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.logging.slf4j.CompleteExceptionLogging;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.template.SourceTemplate;

public class Slf4jLogShouldBeConstant
extends Recipe {
    private static final MethodMatcher SLF4J_LOG = new MethodMatcher("org.slf4j.Logger *(..)");
    private static final MethodMatcher STRING_FORMAT = new MethodMatcher("java.lang.String format(..)");
    private static final MethodMatcher STRING_VALUE_OF = new MethodMatcher("java.lang.String valueOf(..)");

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public String getDisplayName() {
        return "SLF4J logging statements should begin with constants";
    }

    public String getDescription() {
        return "Logging statements shouldn't begin with `String#format`, calls to `toString()`, etc.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesMethod(SLF4J_LOG);
    }

    public Set<String> getTags() {
        return new HashSet<String>(Arrays.asList("logging", "slf4j"));
    }

    protected JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                String name;
                if (SLF4J_LOG.matches(method) && ("trace".equals(name = method.getSimpleName()) || "debug".equals(name) || "info".equals(name) || "warn".equals(name) || "error".equals(name))) {
                    List args = method.getArguments();
                    if (STRING_FORMAT.matches((Expression)args.get(0))) {
                        J.MethodInvocation stringFormat = (J.MethodInvocation)args.get(0);
                        if (stringFormat.getArguments() == null || stringFormat.getArguments().size() <= 1 || !CompleteExceptionLogging.isStringLiteral((Expression)stringFormat.getArguments().get(0))) {
                            return method;
                        }
                        String strFormat = ((J.Literal)stringFormat.getArguments().get(0)).getValue().toString();
                        if (Slf4jLogShouldBeConstant.containsIndexFormatSpecifier(strFormat)) {
                            return method;
                        }
                        String updatedStrFormat = Slf4jLogShouldBeConstant.replaceFormatSpecifier(strFormat, "{}");
                        return method.withArguments(ListUtils.map((List)stringFormat.getArguments(), (n, arg) -> {
                            if (n == 0) {
                                J.Literal str = (J.Literal)arg;
                                return str.withValue((Object)updatedStrFormat).withValueSource("\"" + updatedStrFormat + "\"");
                            }
                            return arg;
                        }));
                    }
                    if (STRING_VALUE_OF.matches((Expression)args.get(0))) {
                        Expression valueOf = (Expression)((J.MethodInvocation)args.get(0)).getArguments().get(0);
                        if (TypeUtils.isAssignableTo((JavaType)JavaType.ShallowClass.build((String)"java.lang.Throwable"), (JavaType)valueOf.getType())) {
                            J.MethodInvocation m = (J.MethodInvocation)method.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)"\"Exception\", #{any()}").build(), method.getCoordinates().replaceArguments(), new Object[]{valueOf});
                            m = m.withSelect(method.getSelect());
                            return m;
                        }
                    } else if (args.get(0) instanceof J.MethodInvocation && "toString".equals(((J.MethodInvocation)args.get(0)).getSimpleName())) {
                        Expression valueOf = ((J.MethodInvocation)args.get(0)).getSelect();
                        J.MethodInvocation m = (J.MethodInvocation)method.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)"\"{}\", #{any()}").build(), method.getCoordinates().replaceArguments(), new Object[]{valueOf});
                        m = m.withSelect(method.getSelect());
                        return m;
                    }
                }
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
        };
    }

    private static String replaceFormatSpecifier(String str, String replacement) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        Pattern pattern = Pattern.compile("%[\\d\\.]*[dfscbBhHn%]");
        Matcher matcher = pattern.matcher(str);
        return matcher.replaceAll(replacement);
    }

    private static boolean containsIndexFormatSpecifier(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        String indexSpecifierRegex = ".*%(\\d+\\$)[a-zA-Z].*";
        return str.matches(indexSpecifierRegex);
    }
}

