/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging;

import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.template.SourceTemplate;

public final class ParameterizedLogging
extends Recipe {
    @Option(displayName="Method pattern", description="A method used to find matching statements to parameterize.", example="org.slf4j.Logger info(..)")
    private final String methodPattern;

    public String getDisplayName() {
        return "Parameterize logging statements";
    }

    public String getDescription() {
        return "Transform logging statements using concatenation for messages and variables into a parameterized format. For example, `logger.info(\"hi \" + userName)` becomes `logger.info(\"hi {}\", userName)`.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesMethod(this.methodPattern);
    }

    public JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){
            private final MethodMatcher matcher;
            {
                this.matcher = new MethodMatcher(ParameterizedLogging.this.methodPattern);
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                if (this.matcher.matches(m) && !m.getArguments().isEmpty() && !(m.getArguments().get(0) instanceof J.Empty) && m.getArguments().size() <= 2) {
                    Expression logMsg = (Expression)m.getArguments().get(0);
                    if (logMsg instanceof J.Binary) {
                        StringBuilder messageBuilder = new StringBuilder("\"");
                        ArrayList newArgList = new ArrayList();
                        ListUtils.map((List)m.getArguments(), (index, message) -> {
                            if (index == 0 && message instanceof J.Binary) {
                                MessageAndArguments literalAndArgs = ParameterizedLogging.concatenationToLiteral(message, new MessageAndArguments("", new ArrayList()));
                                messageBuilder.append(ParameterizedLogging.escapeJava(literalAndArgs.message));
                                newArgList.addAll(literalAndArgs.arguments);
                            } else {
                                newArgList.add(message);
                            }
                            return message;
                        });
                        messageBuilder.append("\"");
                        newArgList.forEach(arg -> messageBuilder.append(", #{any()}"));
                        m = (J.MethodInvocation)m.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)messageBuilder.toString()).build(), m.getCoordinates().replaceArguments(), newArgList.toArray());
                    } else if ((!TypeUtils.isString((JavaType)logMsg.getType()) || logMsg instanceof J.MethodInvocation) && logMsg.getType() instanceof JavaType.Class) {
                        StringBuilder messageBuilder = new StringBuilder("\"{}\"");
                        m.getArguments().forEach(arg -> messageBuilder.append(", #{any()}"));
                        m = (J.MethodInvocation)m.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)messageBuilder.toString()).build(), m.getCoordinates().replaceArguments(), m.getArguments().toArray());
                    }
                }
                return m;
            }
        };
    }

    private static MessageAndArguments concatenationToLiteral(Expression message, MessageAndArguments result) {
        if (!(message instanceof J.Binary)) {
            result.arguments.add(message);
            return result;
        }
        J.Binary concat = (J.Binary)message;
        if (concat.getLeft() instanceof J.Binary && ((J.Binary)concat.getLeft()).getOperator() == J.Binary.Type.Addition) {
            ParameterizedLogging.concatenationToLiteral(concat.getLeft(), result);
        } else if (concat.getLeft() instanceof J.Literal) {
            result.message = ((J.Literal)concat.getLeft()).getValue() + result.message;
        } else {
            result.message = "{}" + result.message;
            result.arguments.add(concat.getLeft());
        }
        if (concat.getRight() instanceof J.Binary && ((J.Binary)concat.getRight()).getOperator() == J.Binary.Type.Addition) {
            ParameterizedLogging.concatenationToLiteral(concat.getRight(), result);
        } else if (concat.getRight() instanceof J.Literal) {
            result.message = result.message + ((J.Literal)concat.getRight()).getValue();
        } else {
            if (result.message.endsWith("#")) {
                result.message = result.message + "\\";
            }
            result.message = result.message + "{}";
            result.arguments.add(concat.getRight());
        }
        return result;
    }

    private static String escapeJava(String value) {
        return value.replace("\"", "\\\\\"").replace("\r", "\\\\r").replace("\n", "\\\\n").replace("\t", "\\\\t");
    }

    @ConstructorProperties(value={"methodPattern"})
    public ParameterizedLogging(String methodPattern) {
        this.methodPattern = methodPattern;
    }

    public String getMethodPattern() {
        return this.methodPattern;
    }

    @NonNull
    public String toString() {
        return "ParameterizedLogging(methodPattern=" + this.getMethodPattern() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParameterizedLogging)) {
            return false;
        }
        ParameterizedLogging other = (ParameterizedLogging)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        return !(this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ParameterizedLogging;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        return result;
    }

    private static final class MessageAndArguments {
        private final List<Expression> arguments;
        private String message;

        private MessageAndArguments(String message, List<Expression> arguments) {
            this.message = message;
            this.arguments = arguments;
        }
    }
}

