/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging.logback;

import java.time.Duration;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.AddImport;
import org.openrewrite.java.ChangeMethodName;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.ImplementInterface;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.template.SourceTemplate;

public class Log4jLayoutToLogback
extends Recipe {
    public String getDisplayName() {
        return "Migrate Log4j 2.x Layout to logback-classic equivalents";
    }

    public String getDescription() {
        return "Migrates custom Log4j 2.x Layout components to `logback-classic`. This recipe operates on the following assumptions: 1.) A logback-classic layout must extend the `LayoutBase<ILoggingEvent>` class. 2.) log4j's `format()` is renamed to `doLayout()` in a logback-classic layout. 3.) LoggingEvent `getRenderedMessage()` is converted to LoggingEvent `getMessage()`. 4.) The log4j ignoresThrowable() method is not needed and has no equivalent in logback-classic. 5.) The activateOptions() method merits further discussion. In log4j, a layout will have its activateOptions() method invoked by log4j configurators, that is PropertyConfigurator or DOMConfigurator just after all the options of the layout have been set. Thus, the layout will have an opportunity to check that its options are coherent and if so, proceed to fully initialize itself. 6.) In logback-classic, layouts must implement the LifeCycle interface which includes a method called start(). The start() method is the equivalent of log4j's activateOptions() method. For more details, see this page from logback: [`Migration from log4j`](http://logback.qos.ch/manual/migrationFromLog4j.html).";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType("org.apache.log4j.Layout");
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
                this.doAfterVisit((Recipe)new ChangeMethodName("org.apache.log4j.Layout format(..)", "doLayout", Boolean.valueOf(true), null));
                this.doAfterVisit((Recipe)new ChangeMethodName("org.apache.log4j.spi.LoggingEvent getRenderedMessage()", "getMessage", Boolean.valueOf(true), null));
                return super.visitCompilationUnit(cu, (Object)ctx);
            }

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
                if (cd.getExtends() != null && cd.getExtends().getType() != null) {
                    JavaType.FullyQualified fullyQualifiedExtends = TypeUtils.asFullyQualified((JavaType)cd.getExtends().getType());
                    if (fullyQualifiedExtends != null && "org.apache.log4j.Layout".equals(fullyQualifiedExtends.getFullyQualifiedName())) {
                        this.maybeRemoveImport("org.apache.log4j.Layout");
                        this.maybeRemoveImport("org.apache.log4j.LoggingEvent");
                        this.maybeAddImport("ch.qos.logback.core.LayoutBase");
                        this.maybeAddImport("ch.qos.logback.classic.spi.ILoggingEvent");
                        this.doAfterVisit((Recipe)new ChangeType("org.apache.log4j.spi.LoggingEvent", "ch.qos.logback.classic.spi.ILoggingEvent", null));
                        cd = (J.ClassDeclaration)cd.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)"LayoutBase<ILoggingEvent>").imports(new String[]{"ch.qos.logback.core.LayoutBase", "ch.qos.logback.classic.spi.ILoggingEvent"}).javaParser(() -> JavaParser.fromJavaVersion().dependsOn(new String[]{"package ch.qos.logback.classic.spi;public interface ILoggingEvent{ }", "package org.apache.log4j.spi;public class LoggingEvent { public String getRenderedMessage() {return null;}}"}).build()).build(), cd.getCoordinates().replaceExtendsClause(), new Object[0]);
                        this.doAfterVisit((TreeVisitor)new AddImport("ch.qos.logback.core.LayoutBase", null, false));
                    }
                    cd = cd.withBody(cd.getBody().withStatements(ListUtils.map((List)cd.getBody().getStatements(), statement -> {
                        if (statement instanceof J.MethodDeclaration) {
                            J.MethodDeclaration method = (J.MethodDeclaration)statement;
                            if ("ignoresThrowable".equals(method.getSimpleName())) {
                                return null;
                            }
                            if ("activateOptions".equals(method.getSimpleName())) {
                                if (method.getBody() != null && method.getBody().getStatements().isEmpty()) {
                                    return null;
                                }
                                J.ClassDeclaration enclosingClass = (J.ClassDeclaration)this.getCursor().firstEnclosing(J.ClassDeclaration.class);
                                assert (enclosingClass != null);
                                this.doAfterVisit((TreeVisitor)new ImplementInterface(enclosingClass, "ch.qos.logback.core.spi.LifeCycle"));
                                return method.withName(method.getName().withSimpleName("start"));
                            }
                        }
                        return statement;
                    })));
                }
                return cd;
            }
        };
    }
}

