/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging.slf4j;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class CompleteExceptionLogging
extends Recipe {
    private static final MethodMatcher LOGGER_DEBUG = new MethodMatcher("org.slf4j.Logger debug(..)");
    private static final MethodMatcher LOGGER_ERROR = new MethodMatcher("org.slf4j.Logger error(..)");
    private static final MethodMatcher LOGGER_INFO = new MethodMatcher("org.slf4j.Logger info(..)");
    private static final MethodMatcher LOGGER_TRACE = new MethodMatcher("org.slf4j.Logger trace(..)");
    private static final MethodMatcher LOGGER_WARN = new MethodMatcher("org.slf4j.Logger warn(..)");
    private static final MethodMatcher THROWABLE_GET_MESSAGE = new MethodMatcher("java.lang.Throwable getMessage()");
    private static final MethodMatcher THROWABLE_GET_LOCALIZED_MESSAGE = new MethodMatcher("java.lang.Throwable getLocalizedMessage()");

    public String getDisplayName() {
        return "Enhances logging of exceptions by including the full stack trace in addition to the exception message";
    }

    public String getDescription() {
        return "It is a common mistake to call `Exception.getMessage()` when passing an exception into a log method. Not all exception types have useful messages, and even if the message is useful this omits the stack trace. Including a complete stack trace of the error along with the exception message in the log allows developers to better understand the context of the exception and identify the source of the error more quickly and accurately. \n If the method invocation includes any call to `Exception.getMessage()` or `Exception.getLocalizedMessage()` and not an exception is already passed as the last parameter to the log method, then we will append the exception as the last parameter in the log method.";
    }

    public Set<String> getTags() {
        return new HashSet<String>(Arrays.asList("logging", "slf4j"));
    }

    @Nullable
    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("org.slf4j.Logger", null), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                method = super.visitMethodInvocation(method, (Object)ctx);
                if (LOGGER_DEBUG.matches(method) || LOGGER_ERROR.matches(method) || LOGGER_INFO.matches(method) || LOGGER_TRACE.matches(method) || LOGGER_WARN.matches(method)) {
                    boolean isLastParameterAnException;
                    List args = method.getArguments();
                    if (args.isEmpty()) {
                        return method;
                    }
                    Expression lastParameter = (Expression)args.get(args.size() - 1);
                    boolean bl = isLastParameterAnException = lastParameter instanceof J.Identifier && TypeUtils.isAssignableTo((String)"java.lang.Throwable", (JavaType)lastParameter.getType());
                    if (isLastParameterAnException) {
                        return method;
                    }
                    if (method.getArguments().size() == 1 && lastParameter instanceof J.MethodInvocation && (THROWABLE_GET_MESSAGE.matches(lastParameter) || THROWABLE_GET_LOCALIZED_MESSAGE.matches(lastParameter))) {
                        J.MethodInvocation getMessageCall = (J.MethodInvocation)lastParameter;
                        args = ListUtils.insert((List)args, (Object)CompleteExceptionLogging.buildEmptyString(), (int)0);
                        args = ListUtils.mapLast((List)args, a -> getMessageCall.getSelect());
                        return (J.MethodInvocation)this.autoFormat((J)method.withArguments(args), ctx);
                    }
                    Optional maybeException = ((List)new JavaIsoVisitor<List<Expression>>(){

                        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation m, List<Expression> exceptions) {
                            if (THROWABLE_GET_MESSAGE.matches(m) || THROWABLE_GET_LOCALIZED_MESSAGE.matches(m)) {
                                exceptions.add(m.getSelect());
                                return m;
                            }
                            return super.visitMethodInvocation(m, exceptions);
                        }
                    }.reduce((Tree)method, new ArrayList())).stream().findFirst();
                    if (!maybeException.isPresent()) {
                        return method;
                    }
                    if (lastParameter instanceof J.MethodInvocation && (THROWABLE_GET_MESSAGE.matches(lastParameter) || THROWABLE_GET_LOCALIZED_MESSAGE.matches(lastParameter))) {
                        String content;
                        int placeholderCount;
                        J.MethodInvocation getMessageCall = (J.MethodInvocation)lastParameter;
                        Expression firstParameter = (Expression)method.getArguments().get(0);
                        if (CompleteExceptionLogging.isStringLiteral(firstParameter) && (placeholderCount = CompleteExceptionLogging.countPlaceholders(content = ((J.Literal)firstParameter).getValue().toString())) < args.size() - 1) {
                            args.remove(args.size() - 1);
                        }
                    }
                    args = ListUtils.concat((List)args, (Object)((Expression)maybeException.get()));
                    return (J.MethodInvocation)this.autoFormat((J)method.withArguments(args), ctx);
                }
                return method;
            }
        });
    }

    private static int countPlaceholders(String message) {
        int count = 0;
        Pattern pattern = Pattern.compile("\\{}");
        Matcher matcher = pattern.matcher(message);
        while (matcher.find()) {
            ++count;
        }
        return count;
    }

    public static boolean isStringLiteral(Expression expression) {
        return expression instanceof J.Literal && TypeUtils.isString((JavaType)((J.Literal)expression).getType());
    }

    private static J.Literal buildEmptyString() {
        return new J.Literal(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Object)"", "\"\"", null, JavaType.Primitive.String);
    }
}

