/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging.slf4j;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.JavadocVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Javadoc;

public class LoggersNamedForEnclosingClass
extends Recipe {
    private static final MethodMatcher LOGGERFACTORY_GETLOGGER = new MethodMatcher("org.slf4j.LoggerFactory getLogger(Class)");

    public String getDisplayName() {
        return "Loggers should be named for their enclosing classes";
    }

    public String getDescription() {
        return "Ensure `LoggerFactory#getLogger(Class)` is called with the enclosing class as argument.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    public Set<String> getTags() {
        return new HashSet<String>(Arrays.asList("RSPEC-3416", "logging", "slf4j"));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("org.slf4j.LoggerFactory", null), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            protected JavadocVisitor<ExecutionContext> getJavadocVisitor() {
                return new JavadocVisitor<ExecutionContext>((JavaVisitor)this){

                    public Javadoc visitDocComment(Javadoc.DocComment javadoc, ExecutionContext executionContext) {
                        return javadoc;
                    }
                };
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext p) {
                String argumentClazzName;
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)p);
                if (!LOGGERFACTORY_GETLOGGER.matches(mi)) {
                    return mi;
                }
                J.ClassDeclaration firstEnclosingClass = (J.ClassDeclaration)this.getCursor().firstEnclosing(J.ClassDeclaration.class);
                if (firstEnclosingClass == null) {
                    return mi;
                }
                String enclosingClazzName = firstEnclosingClass.getSimpleName() + ".class";
                if (mi.getArguments().get(0) instanceof J.FieldAccess && enclosingClazzName.equals(argumentClazzName = ((J.FieldAccess)mi.getArguments().get(0)).toString())) {
                    return mi;
                }
                if (mi.getArguments().get(0) instanceof J.MethodInvocation && ((J.MethodInvocation)mi.getArguments().get(0)).getName().toString().equals("getClass") && !firstEnclosingClass.hasModifier(J.Modifier.Type.Final)) {
                    return mi;
                }
                return (J.MethodInvocation)JavaTemplate.builder((String)"LoggerFactory.getLogger(#{})").contextSensitive().imports(new String[]{"org.slf4j.LoggerFactory"}).javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"slf4j-api"})).build().apply(new Cursor(this.getCursor().getParent(), (Object)mi), mi.getCoordinates().replace(), new Object[]{enclosingClazzName});
            }
        });
    }
}

