/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging.slf4j;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class JulToSlf4jSimpleCallsWithThrowableRecipes
extends Recipe {
    public String getDisplayName() {
        return "Replace JUL `log(Level, String, Throwable)` with corresponding SLF4J method calls";
    }

    public String getDescription() {
        return "Replace calls to `Logger.log(Level, String, Throwable)` with the corresponding SLF4J method calls.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new JulToSlf4jSupplierFinestRecipe(), new JulToSlf4jSupplierFinerRecipe(), new JulToSlf4jSupplierFineRecipe(), new JulToSlf4jSupplierConfigRecipe(), new JulToSlf4jSupplierInfoRecipe(), new JulToSlf4jSupplierWarningRecipe(), new JulToSlf4jSupplierSevereRecipe(), new JulToSlf4jSupplierAllRecipe()});
    }

    @NonNullApi
    public static class JulToSlf4jSupplierFinestRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `logger.log(Level.FINEST, String message, Throwable e)` with SLF4J's `Logger.trace(message, e)`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.log(Level.FINEST, String message, Throwable e)` with `org.slf4j.Logger.trace(message, e)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.log(java.util.logging.Level.FINEST, #{message:any(java.lang.String)}, #{e:any(java.lang.Throwable)});").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{logger:any(org.slf4j.Logger)}.trace(#{message:any(java.lang.String)}, #{e:any(java.lang.Throwable)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.logging.Level");
                        this.maybeRemoveImport("java.util.logging.Logger");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.logging.Level", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger log(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class JulToSlf4jSupplierFinerRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `logger.log(Level.FINER, String message, Throwable e)` with SLF4J's `Logger.trace(message, e)`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.log(Level.FINER, String message, Throwable e)` with `org.slf4j.Logger.trace(message, e)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.log(java.util.logging.Level.FINER, #{message:any(java.lang.String)}, #{e:any(java.lang.Throwable)});").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{logger:any(org.slf4j.Logger)}.trace(#{message:any(java.lang.String)}, #{e:any(java.lang.Throwable)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.logging.Level");
                        this.maybeRemoveImport("java.util.logging.Logger");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.logging.Level", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger log(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class JulToSlf4jSupplierFineRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `logger.log(Level.FINE, String message, Throwable e)` with SLF4J's `Logger.debug(message, e)`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.log(Level.FINE, String message, Throwable e)` with `org.slf4j.Logger.debug(message, e)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.log(java.util.logging.Level.FINE, #{message:any(java.lang.String)}, #{e:any(java.lang.Throwable)});").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{logger:any(org.slf4j.Logger)}.debug(#{message:any(java.lang.String)}, #{e:any(java.lang.Throwable)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.logging.Level");
                        this.maybeRemoveImport("java.util.logging.Logger");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.logging.Level", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger log(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class JulToSlf4jSupplierConfigRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `logger.log(Level.CONFIG, String message, Throwable e)` with SLF4J's `Logger.info(message, e)`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.log(Level.CONFIG, String message, Throwable e)` with `org.slf4j.Logger.info(message, e)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.log(java.util.logging.Level.CONFIG, #{message:any(java.lang.String)}, #{e:any(java.lang.Throwable)});").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{logger:any(org.slf4j.Logger)}.info(#{message:any(java.lang.String)}, #{e:any(java.lang.Throwable)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.logging.Level");
                        this.maybeRemoveImport("java.util.logging.Logger");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.logging.Level", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger log(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class JulToSlf4jSupplierInfoRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `logger.log(Level.INFO, String message, Throwable e)` with SLF4J's `Logger.info(message, e)`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.log(Level.INFO, String message, Throwable e)` with `org.slf4j.Logger.info(message, e)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.log(java.util.logging.Level.INFO, #{message:any(java.lang.String)}, #{e:any(java.lang.Throwable)});").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{logger:any(org.slf4j.Logger)}.info(#{message:any(java.lang.String)}, #{e:any(java.lang.Throwable)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.logging.Level");
                        this.maybeRemoveImport("java.util.logging.Logger");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.logging.Level", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger log(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class JulToSlf4jSupplierWarningRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `logger.log(Level.WARNING, String message, Throwable e)` with SLF4J's `Logger.warn(message, e)`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.log(Level.WARNING, String message, Throwable e)` with `org.slf4j.Logger.warn(message, e)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.log(java.util.logging.Level.WARNING, #{message:any(java.lang.String)}, #{e:any(java.lang.Throwable)});").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{logger:any(org.slf4j.Logger)}.warn(#{message:any(java.lang.String)}, #{e:any(java.lang.Throwable)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.logging.Level");
                        this.maybeRemoveImport("java.util.logging.Logger");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.logging.Level", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger log(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class JulToSlf4jSupplierSevereRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `logger.log(Level.SEVERE, String message, Throwable e)` with SLF4J's `Logger.error(message, e)`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.log(Level.SEVERE, String message, Throwable e)` with `org.slf4j.Logger.error(message, e)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.log(java.util.logging.Level.SEVERE, #{message:any(java.lang.String)}, #{e:any(java.lang.Throwable)});").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{logger:any(org.slf4j.Logger)}.error(#{message:any(java.lang.String)}, #{e:any(java.lang.Throwable)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.logging.Level");
                        this.maybeRemoveImport("java.util.logging.Logger");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.logging.Level", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger log(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class JulToSlf4jSupplierAllRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `logger.log(Level.ALL, String message, Throwable e)` with SLF4J's `Logger.trace(message, e)`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.log(Level.ALL, String message, Throwable e)` with `org.slf4j.Logger.trace(message, e)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.log(java.util.logging.Level.ALL, #{message:any(java.lang.String)}, #{e:any(java.lang.Throwable)});").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{logger:any(org.slf4j.Logger)}.trace(#{message:any(java.lang.String)}, #{e:any(java.lang.Throwable)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.logging.Level");
                        this.maybeRemoveImport("java.util.logging.Logger");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.logging.Level", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger log(..)")}), (TreeVisitor)javaVisitor);
        }
    }
}

